using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MySql.Data.MySqlClient;

namespace FormElementBinding {
	
	public partial class FormMain : Form {
		private DataTable dataTable = new DataTable ();
		public FormMain () {
			InitializeComponent ();			

			try {
				mySqlConnection.Open ();
				mySqlDataAdapter.Fill (dataTable);
				mySqlConnection.Close ();
			} catch (Exception e) {
				MessageBox.Show ("Error: " + e.Message);
			}

			dataGridViewTeachers.DataSource = dataTable;			
		}

		private void FormMain_Load (object sender, EventArgs e) {

		}

		private void dataGridViewTeachers_CursorChanged (object sender, EventArgs e) {
			
		}

		private void dataGridViewTeachers_Scroll (object sender, ScrollEventArgs e) {
			
		}

		private void dataGridViewTeachers_RowEnter (object sender, DataGridViewCellEventArgs e) {
			try {
				//MessageBox.Show ("Idx: " + e.RowIndex.ToString ());
				textBoxName.Text = dataGridViewTeachers.Rows[e.RowIndex].Cells[1].Value.ToString ();
				textBoxSurname.Text = dataGridViewTeachers.Rows[e.RowIndex].Cells[2].Value.ToString ();

				String teacherID = dataGridViewTeachers.Rows[e.RowIndex].Cells[0].Value.ToString ();

				// Detail goes to DbGrid
				MySqlCommand coursesCmd = mySqlConnection.CreateCommand ();
				coursesCmd.CommandText =
					"SELECT code, name " +
					"FROM subject " +
					"WHERE gestor = '" + teacherID + "'";

				MySqlDataAdapter coursesDataAdapter = new MySqlDataAdapter ();
				coursesDataAdapter.SelectCommand = coursesCmd;
				
				DataTable coursesData = new DataTable ();
				coursesDataAdapter.Fill (coursesData);

				dataGridViewCourses.DataSource = coursesData;
					
			} catch (Exception ex) {
				MessageBox.Show (ex.Message);
			}
		}

		private void groupBoxCourse_Enter (object sender, EventArgs e) {

		}

		private void bindingNavigator_RefreshItems (object sender, EventArgs e) {

		}
	}
}