using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace MySQLConnection {
	public partial class FormMain : Form {
		public FormMain () {
			InitializeComponent ();
		}

		private void FormMain_Load (object sender, EventArgs e) {

		}

		private void buttonConnect_Click (object sender, EventArgs e) {
			if (mySqlConnection.State == ConnectionState.Closed) {
				richTextBoxLog.Clear ();
				mySqlConnection.Open ();
				buttonConnect.Text = "Disconnect";
			} else {
				richTextBoxLog.Clear ();
				mySqlConnection.Close ();
				buttonConnect.Text = "Connect";
			}	
			labelState.Text = "Current state: " + mySqlConnection.State.ToString ();
		}

		private void mySqlConnection_StateChange (object sender, StateChangeEventArgs e) {
			richTextBoxLog.AppendText (
				"State changed from " + e.OriginalState +
				" to " + e.CurrentState + "\n");
		}
	}
}