﻿/* 
 * Copyright (C) 2016 PTM
 * 
 * Object Oriented Programming Course Example File.
 * 
 * Created: 12/01/2016 
 * Authors: Pasi Manninen
 */
using System;

namespace T15
{
    /// <summary> 
    /// This class prints a xmas tree.
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            int number;
            Console.Write("Give number : ");
            string line = Console.ReadLine();
            bool result = Int32.TryParse(line, out number);
            int tree = number - 2;
            int root = number - tree;
            if (result)
            {
                // too small
                if (number < 4)
                {
                    Console.WriteLine("Too small tree!");
                    Console.ReadLine();
                    return;
                } else if (number > 40)
                {
                    Console.WriteLine("Too big tree!");
                    Console.ReadLine();
                    return;
                }
                // tree
                for (int i = 0; i < tree; i++)
                {
                    // spaces length
                    int spacesLength = tree - i;
                    // print spaces
                    for (int space = 0; space <= spacesLength; space++)
                    {
                        Console.Write(" ");
                    }
                    // print stars
                    for (int star = 0; star <= i * 2; star++)
                    {
                        Console.Write("*");
                    }
                    Console.WriteLine();
                }
                // root
                for (int i = 0; i < root; i++)
                {
                    for (int space = 0; space <= tree; space++)
                    {
                        Console.Write(" ");
                    }
                    Console.WriteLine("*");
                }
            }
            else
            {
                Console.WriteLine("You don't give a number!");
            }
            Console.ReadLine();
        }
    }
}
