﻿/* 
 * Copyright (C) 2016 PTM
 * 
 * Object Oriented Programming Course Example File.
 * 
 * Created: 12/01/2016 
 * Authors: Pasi Manninen
 */
using System;
using System.Text;

namespace T19
{
    /// <summary> 
    /// This class demonstrates hangman in console...
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            string rightWord = "HANGMAN";
            StringBuilder guessedWord = new StringBuilder("_______");
            StringBuilder guessedLetters = new StringBuilder("");
            int hangMax = 10;
            int guesses = 0;
            do
            {
                // ask a new letter
                Console.Write("Give letter : ");
                string line = Console.ReadLine().ToUpper();
                if (line.Length == 0)
                {
                    Console.WriteLine("You don't type anything (Game Over)!");
                    return;
                }
                guesses++;
                // check letter in rightword
                for (int i=0;i<rightWord.Length;i++)
                {
                    if (rightWord[i] == line[0]) {
                        guessedWord[i] = line[0];
                    }
                }
                // store guessed letter
                guessedLetters.Append(line[0]);
                Console.WriteLine("Guessed word: {0}", guessedWord.ToString());
                Console.WriteLine("Guesses made: {0} and left {1}", guesses, hangMax-guesses);
                Console.WriteLine("Guessed letters: {0}", guessedLetters.ToString());
            } while (guesses < hangMax && !rightWord.Equals(guessedWord.ToString()));

            if (rightWord.Equals(guessedWord.ToString()))
            {
                Console.WriteLine("Excellent - you survive!");
            }
            else
            {
                Console.WriteLine("Sorry - you hang now..!");
            }

            Console.ReadLine();
        }
    }
}
