/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import jugglinglab.core.Animator;
import jugglinglab.core.EditLadderDiagram;
import jugglinglab.core.LadderDiagram;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLMath;
import jugglinglab.util.JuggleExceptionInternal;

public class AnimatorEdit
extends Animator {
    protected LadderDiagram ladder = null;
    protected boolean event_active = false;
    protected JMLEvent event;
    protected int xlow1;
    protected int xhigh1;
    protected int ylow1;
    protected int yhigh1;
    protected int xlow2;
    protected int xhigh2;
    protected int ylow2;
    protected int yhigh2;
    protected boolean dragging = false;
    protected boolean dragging_left = false;
    protected int xstart;
    protected int ystart;
    protected int xdelta;
    protected int ydelta;

    protected void initHandlers() {
        JMLPattern jMLPattern = this.pat;
        this.addMouseListener(new MouseAdapter(){
            long lastpress = 0L;
            long lastenter = 1L;

            public void mousePressed(MouseEvent mouseEvent) {
                this.lastpress = mouseEvent.getWhen();
                if (AnimatorEdit.this.jc.mousePause && this.lastpress == this.lastenter) {
                    return;
                }
                if (AnimatorEdit.this.exception != null) {
                    return;
                }
                if (!AnimatorEdit.this.engineStarted) {
                    return;
                }
                if (AnimatorEdit.this.event_active) {
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    if (n >= AnimatorEdit.this.xlow1 && n <= AnimatorEdit.this.xhigh1 && n2 >= AnimatorEdit.this.ylow1 && n2 <= AnimatorEdit.this.yhigh1) {
                        AnimatorEdit.this.dragging = true;
                        AnimatorEdit.this.dragging_left = true;
                        AnimatorEdit.this.xstart = n;
                        AnimatorEdit.this.ystart = n2;
                        AnimatorEdit.this.ydelta = 0;
                        AnimatorEdit.this.xdelta = 0;
                        return;
                    }
                    int n3 = AnimatorEdit.this.getSize().width / 2;
                    if (n >= AnimatorEdit.this.xlow2 + n3 && n <= AnimatorEdit.this.xhigh2 + n3 && n2 >= AnimatorEdit.this.ylow2 && n2 <= AnimatorEdit.this.yhigh2) {
                        AnimatorEdit.this.dragging = true;
                        AnimatorEdit.this.dragging_left = false;
                        AnimatorEdit.this.xstart = n;
                        AnimatorEdit.this.ystart = n2;
                        AnimatorEdit.this.ydelta = 0;
                        AnimatorEdit.this.xdelta = 0;
                        return;
                    }
                }
                AnimatorEdit.this.startx = mouseEvent.getX();
                AnimatorEdit.this.starty = mouseEvent.getY();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (AnimatorEdit.this.jc.mousePause && this.lastpress == this.lastenter) {
                    return;
                }
                if (AnimatorEdit.this.exception != null) {
                    return;
                }
                if (!AnimatorEdit.this.engineStarted && AnimatorEdit.this.engine != null && AnimatorEdit.this.engine.isAlive()) {
                    AnimatorEdit.this.setPaused(!AnimatorEdit.this.enginePaused);
                    return;
                }
                if (AnimatorEdit.this.event_active && AnimatorEdit.this.dragging) {
                    Coordinate coordinate;
                    JMLEvent jMLEvent = AnimatorEdit.this.event.isMaster() ? AnimatorEdit.this.event : AnimatorEdit.this.event.getMaster();
                    boolean bl = AnimatorEdit.this.event.getHand() != jMLEvent.getHand();
                    Coordinate coordinate2 = AnimatorEdit.this.ren1.getScreenTranslatedCoordinate(AnimatorEdit.this.event.getGlobalCoordinate(), AnimatorEdit.this.xdelta, AnimatorEdit.this.ydelta);
                    if (AnimatorEdit.this.jc.stereo) {
                        coordinate = AnimatorEdit.this.ren2.getScreenTranslatedCoordinate(AnimatorEdit.this.event.getGlobalCoordinate(), AnimatorEdit.this.xdelta, AnimatorEdit.this.ydelta);
                        coordinate2 = Coordinate.add(coordinate2, coordinate);
                        coordinate2.setCoordinate(0.5 * coordinate2.x, 0.5 * coordinate2.y, 0.5 * coordinate2.z);
                    }
                    coordinate = AnimatorEdit.this.pat.convertGlobalToLocal(coordinate2, AnimatorEdit.this.event.getJuggler(), AnimatorEdit.this.event.getT());
                    Coordinate coordinate3 = Coordinate.sub(coordinate, AnimatorEdit.this.event.getLocalCoordinate());
                    if (bl) {
                        coordinate3.x = -coordinate3.x;
                    }
                    Coordinate coordinate4 = jMLEvent.getLocalCoordinate();
                    jMLEvent.setLocalCoordinate(Coordinate.add(coordinate4, coordinate3));
                    AnimatorEdit.this.ydelta = 0;
                    AnimatorEdit.this.xdelta = 0;
                    EditLadderDiagram editLadderDiagram = (EditLadderDiagram)AnimatorEdit.this.ladder;
                    editLadderDiagram.activeEventMoved();
                }
                AnimatorEdit.this.cameradrag = false;
                AnimatorEdit.this.dragging = false;
                if (mouseEvent.getX() == AnimatorEdit.this.startx && mouseEvent.getY() == AnimatorEdit.this.starty && AnimatorEdit.this.engine != null && AnimatorEdit.this.engine.isAlive()) {
                    AnimatorEdit.this.setPaused(!AnimatorEdit.this.enginePaused);
                }
                if (AnimatorEdit.this.getPaused()) {
                    AnimatorEdit.this.repaint();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                this.lastenter = mouseEvent.getWhen();
                if (AnimatorEdit.this.jc.mousePause) {
                    AnimatorEdit.this.setPaused(AnimatorEdit.this.waspaused);
                }
                AnimatorEdit.this.outside = false;
                AnimatorEdit.this.outside_valid = true;
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (AnimatorEdit.this.jc.mousePause) {
                    AnimatorEdit.this.waspaused = AnimatorEdit.this.getPaused();
                    AnimatorEdit.this.setPaused(true);
                }
                AnimatorEdit.this.outside = true;
                AnimatorEdit.this.outside_valid = true;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                int n;
                int n2;
                if (AnimatorEdit.this.exception != null) {
                    return;
                }
                if (!AnimatorEdit.this.engineStarted) {
                    return;
                }
                if (AnimatorEdit.this.dragging) {
                    n2 = mouseEvent.getX();
                    n = mouseEvent.getY();
                    AnimatorEdit.this.xdelta = n2 - AnimatorEdit.this.xstart;
                    AnimatorEdit.this.ydelta = n - AnimatorEdit.this.ystart;
                    AnimatorEdit.this.repaint();
                } else if (!AnimatorEdit.this.cameradrag) {
                    AnimatorEdit.this.cameradrag = true;
                    AnimatorEdit.this.lastx = AnimatorEdit.this.startx;
                    AnimatorEdit.this.lasty = AnimatorEdit.this.starty;
                    AnimatorEdit.this.camangle = AnimatorEdit.this.ren1.getCameraAngle();
                }
                if (!AnimatorEdit.this.cameradrag) {
                    return;
                }
                n2 = mouseEvent.getX() - AnimatorEdit.this.lastx;
                n = mouseEvent.getY() - AnimatorEdit.this.lasty;
                AnimatorEdit.this.lastx = mouseEvent.getX();
                AnimatorEdit.this.lasty = mouseEvent.getY();
                double[] dArray = AnimatorEdit.this.camangle;
                dArray[0] = dArray[0] + (double)n2 * 0.02;
                dArray[1] = dArray[1] - (double)n * 0.02;
                if (dArray[1] < 1.0E-4) {
                    dArray[1] = 1.0E-4;
                }
                if (dArray[1] > JLMath.toRad(90.0)) {
                    dArray[1] = JLMath.toRad(90.0);
                }
                while (dArray[0] < 0.0) {
                    dArray[0] = dArray[0] + JLMath.toRad(360.0);
                }
                while (dArray[0] >= JLMath.toRad(360.0)) {
                    dArray[0] = dArray[0] - JLMath.toRad(360.0);
                }
                AnimatorEdit.this.setCameraAngle(dArray);
                if (AnimatorEdit.this.event_active) {
                    AnimatorEdit.this.createEventView();
                }
                if (AnimatorEdit.this.getPaused()) {
                    AnimatorEdit.this.repaint();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (AnimatorEdit.this.exception != null) {
                    return;
                }
                if (!AnimatorEdit.this.engineStarted) {
                    return;
                }
                AnimatorEdit.this.syncRenderer();
                AnimatorEdit.this.repaint();
            }
        });
    }

    protected double[] snapCamera(double[] dArray) {
        double[] dArray2 = super.snapCamera(dArray);
        if (this.event_active) {
            double d = JLMath.toRad(this.pat.getJugglerAngle(this.event.getJuggler(), this.event.getT()));
            if (this.anglediff(d - dArray2[0]) < snapangle) {
                dArray2[0] = d;
            } else if (this.anglediff(d + 1.5707963267460001 - dArray2[0]) < snapangle) {
                dArray2[0] = d + 1.5707963267460001;
            } else if (this.anglediff(d + 3.1415926534920002 - dArray2[0]) < snapangle) {
                dArray2[0] = d + 3.1415926534920002;
            } else if (this.anglediff(d + 4.712388980238 - dArray2[0]) < snapangle) {
                dArray2[0] = d + 4.712388980238;
            }
        }
        return dArray2;
    }

    protected double anglediff(double d) {
        while (d > JLMath.toRad(180.0)) {
            d -= JLMath.toRad(360.0);
        }
        while (d <= JLMath.toRad(-180.0)) {
            d += JLMath.toRad(360.0);
        }
        return Math.abs(d);
    }

    public void setLadderDiagram(LadderDiagram ladderDiagram) {
        this.ladder = ladderDiagram;
    }

    public void setTime(double d) {
        super.setTime(d);
        if (this.ladder != null) {
            this.ladder.setTime(d);
        }
    }

    public void activateEvent(JMLEvent jMLEvent) {
        if (this.ladder != null && !(this.ladder instanceof EditLadderDiagram)) {
            return;
        }
        this.event = jMLEvent;
        this.event_active = true;
        this.createEventView();
    }

    public void deactivateEvent() {
        this.event_active = false;
    }

    protected void createEventView() {
        if (this.event_active) {
            Coordinate coordinate = this.event.getGlobalCoordinate();
            Coordinate coordinate2 = this.ren1.getScreenTranslatedCoordinate(coordinate, 1, 0);
            Coordinate coordinate3 = Coordinate.sub(coordinate, coordinate2);
            double d = Math.sqrt(coordinate3.x * coordinate3.x + coordinate3.y * coordinate3.y + coordinate3.z * coordinate3.z);
            int n = (int)(0.5 + 5.0 / d);
            int[] nArray = this.ren1.getXY(coordinate);
            this.xlow1 = nArray[0] - n;
            this.ylow1 = nArray[1] - n;
            this.xhigh1 = nArray[0] + n;
            this.yhigh1 = nArray[1] + n;
            if (this.jc.stereo) {
                coordinate = this.event.getGlobalCoordinate();
                coordinate2 = this.ren2.getScreenTranslatedCoordinate(coordinate, 1, 0);
                coordinate3 = Coordinate.sub(coordinate, coordinate2);
                d = Math.sqrt(coordinate3.x * coordinate3.x + coordinate3.y * coordinate3.y + coordinate3.z * coordinate3.z);
                n = (int)(0.5 + 5.0 / d);
                nArray = this.ren2.getXY(coordinate);
                this.xlow2 = nArray[0] - n;
                this.ylow2 = nArray[1] - n;
                this.xhigh2 = nArray[0] + n;
                this.yhigh2 = nArray[1] + n;
            }
        }
    }

    protected void syncRenderer() {
        super.syncRenderer();
        if (this.event_active) {
            this.createEventView();
        }
    }

    protected void drawFrame(double d, int[] nArray, Graphics graphics) throws JuggleExceptionInternal {
        Graphics2D graphics2D;
        super.drawFrame(d, nArray, graphics);
        if (!this.event_active) {
            return;
        }
        Dimension dimension = this.getSize();
        Graphics graphics2 = graphics;
        if (this.jc.stereo) {
            graphics2 = graphics.create(0, 0, dimension.width / 2, dimension.height);
        }
        if (graphics2 instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics2;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2.setColor(Color.green);
        graphics2.drawLine(this.xlow1 + this.xdelta, this.ylow1 + this.ydelta, this.xhigh1 + this.xdelta, this.ylow1 + this.ydelta);
        graphics2.drawLine(this.xhigh1 + this.xdelta, this.ylow1 + this.ydelta, this.xhigh1 + this.xdelta, this.yhigh1 + this.ydelta);
        graphics2.drawLine(this.xhigh1 + this.xdelta, this.yhigh1 + this.ydelta, this.xlow1 + this.xdelta, this.yhigh1 + this.ydelta);
        graphics2.drawLine(this.xlow1 + this.xdelta, this.yhigh1 + this.ydelta, this.xlow1 + this.xdelta, this.ylow1 + this.ydelta);
        if (this.jc.stereo) {
            graphics2 = graphics.create(dimension.width / 2, 0, dimension.width / 2, dimension.height);
            if (graphics2 instanceof Graphics2D) {
                graphics2D = (Graphics2D)graphics2;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            graphics2.setColor(Color.green);
            graphics2.drawLine(this.xlow2 + this.xdelta, this.ylow2 + this.ydelta, this.xhigh2 + this.xdelta, this.ylow2 + this.ydelta);
            graphics2.drawLine(this.xhigh2 + this.xdelta, this.ylow2 + this.ydelta, this.xhigh2 + this.xdelta, this.yhigh2 + this.ydelta);
            graphics2.drawLine(this.xhigh2 + this.xdelta, this.yhigh2 + this.ydelta, this.xlow2 + this.xdelta, this.yhigh2 + this.ydelta);
            graphics2.drawLine(this.xlow2 + this.xdelta, this.yhigh2 + this.ydelta, this.xlow2 + this.xdelta, this.ylow2 + this.ydelta);
        }
    }
}

