/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import gifwriter.GIFAnimWriter;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import jugglinglab.core.Animator;
import jugglinglab.core.PBUpdater;
import jugglinglab.core.PlatformSpecific;
import jugglinglab.jml.JMLPattern;
import jugglinglab.renderer.Renderer;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionInternal;

public class AnimatorGIFWriter
extends Thread {
    static ResourceBundle guistrings = JLLocale.getBundle("GUIStrings");
    Animator ja = null;
    JMLPattern pat = null;
    Renderer ren1 = null;
    Renderer ren2 = null;
    int num_frames;
    double sim_interval_secs;
    long real_interval_millis;
    OutputStream out = null;

    public AnimatorGIFWriter() {
        this.setPriority(1);
    }

    public void setup(Animator animator, Renderer renderer, Renderer renderer2, int n, double d, long l) {
        this.ja = animator;
        this.pat = animator.getPattern();
        this.ren1 = renderer;
        this.ren2 = renderer2;
        this.num_frames = n;
        this.sim_interval_secs = d;
        this.real_interval_millis = l;
    }

    public void run() {
        try {
            boolean bl = this.ja.getPaused();
            this.ja.setPaused(true);
            try {
                FileOutputStream fileOutputStream = null;
                ProgressMonitor progressMonitor = null;
                int n = PlatformSpecific.getPlatformSpecific().showSaveDialog(this.ja);
                if (n == 0 && PlatformSpecific.getPlatformSpecific().getSelectedFile() != null) {
                    int n2;
                    this.ja.setCursor(Cursor.getPredefinedCursor(3));
                    File file = PlatformSpecific.getPlatformSpecific().getSelectedFile();
                    fileOutputStream = new FileOutputStream(file);
                    GIFAnimWriter gIFAnimWriter = new GIFAnimWriter();
                    Dimension dimension = this.ja.getSize();
                    int n3 = dimension.width;
                    int n4 = dimension.height;
                    Image image = this.ja.createImage(n3, n4);
                    Graphics graphics = image.getGraphics();
                    int[] nArray = new int[this.pat.getNumberOfPaths()];
                    for (n2 = 0; n2 < this.pat.getNumberOfPaths(); ++n2) {
                        nArray[n2] = this.pat.getPropAssignment(n2 + 1);
                    }
                    n2 = this.pat.getPeriod();
                    int n5 = n2 * this.num_frames * 2;
                    int n6 = 0;
                    progressMonitor = new ProgressMonitor(this.ja, guistrings.getString("Saving_animated_GIF"), "", 0, n5);
                    boolean bl2 = false;
                    for (int i = 0; i < 2; ++i) {
                        if (i == 1) {
                            gIFAnimWriter.writeHeader(fileOutputStream);
                        }
                        for (int j = 0; j < n2; ++j) {
                            double d = this.pat.getLoopStartTime();
                            for (int k = 0; k < this.num_frames; ++k) {
                                if (i == 1) {
                                    gIFAnimWriter.writeDelay((int)(this.real_interval_millis / 10L), fileOutputStream);
                                }
                                if (this.ren2 != null) {
                                    this.ren1.drawFrame(d, nArray, graphics.create(0, 0, dimension.width / 2, dimension.height), this.ja);
                                    this.ren2.drawFrame(d, nArray, graphics.create(dimension.width / 2, 0, dimension.width / 2, dimension.height), this.ja);
                                } else {
                                    this.ren1.drawFrame(d, nArray, graphics, this.ja);
                                }
                                if (i == 0) {
                                    gIFAnimWriter.doColorMap(image);
                                } else {
                                    gIFAnimWriter.writeGIF(image, fileOutputStream);
                                }
                                if (progressMonitor != null) {
                                    String string = i == 0 ? guistrings.getString("Message_GIFsave_color_map") : guistrings.getString("Message_GIFsave_writing_frame") + " " + (++n6 - this.num_frames) + "/" + this.num_frames;
                                    SwingUtilities.invokeLater(new PBUpdater(progressMonitor, n6, string));
                                    if (progressMonitor.isCanceled()) {
                                        return;
                                    }
                                }
                                d += this.sim_interval_secs;
                            }
                            this.ja.advanceProps(nArray);
                        }
                    }
                    gIFAnimWriter.writeTrailer(fileOutputStream);
                    graphics.dispose();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JuggleExceptionInternal("AnimGIFSave file not found: " + fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                throw new JuggleExceptionInternal("AnimGIFSave IOException: " + iOException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JuggleExceptionInternal("AnimGIFSave IllegalArgumentException: " + illegalArgumentException.getMessage());
            }
            finally {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {}
                }
                this.ja.setCursor(Cursor.getDefaultCursor());
                this.ja.setPaused(bl);
            }
        }
        catch (Exception exception) {
            ErrorDialog.handleException(exception);
        }
        this.ja.writingGIF = false;
    }
}

