/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import jugglinglab.core.AnimatorPrefs;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.View;

public class PatternWindow
extends JFrame
implements ActionListener {
    protected View view = null;
    protected JMenu filemenu = null;
    protected JMenu viewmenu = null;

    public PatternWindow(String string, JMLPattern jMLPattern, AnimatorPrefs animatorPrefs) throws JuggleExceptionUser, JuggleExceptionInternal {
        this(string, jMLPattern, animatorPrefs, new Dimension(400, 450));
    }

    public PatternWindow(String string, JMLPattern jMLPattern, AnimatorPrefs animatorPrefs, Dimension dimension) throws JuggleExceptionUser, JuggleExceptionInternal {
        super(string);
        JMenuItem jMenuItem;
        this.view = new View(this, dimension);
        JMenuBar jMenuBar = new JMenuBar();
        this.filemenu = this.view.createFileMenu();
        jMenuBar.add(this.filemenu);
        this.viewmenu = this.view.createViewMenu();
        for (int i = 0; i < this.viewmenu.getItemCount() && (jMenuItem = this.viewmenu.getItem(i)) != null; ++i) {
            jMenuItem.addActionListener(this);
        }
        jMenuBar.add(this.viewmenu);
        this.setJMenuBar(jMenuBar);
        if (jMLPattern.getNumberOfJugglers() > 1) {
            this.view.setViewMode(1);
            this.viewmenu.getItem(0).setSelected(true);
        } else {
            this.view.setViewMode(2);
            this.viewmenu.getItem(1).setSelected(true);
        }
        this.setDefaultCloseOperation(2);
        this.view.setDoubleBuffered(true);
        this.setBackground(Color.white);
        this.setContentPane(this.view);
        Locale locale = JLLocale.getLocale();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        this.pack();
        this.view.restartView(jMLPattern, animatorPrefs);
        this.setVisible(true);
    }

    protected void restartJuggle(String string, JMLPattern jMLPattern, AnimatorPrefs animatorPrefs) throws JuggleException {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (string != null) {
            this.setTitle(string);
        }
        this.view.restartView(jMLPattern, animatorPrefs);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        for (int i = 0; i < this.filemenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.filemenu.getItem(i);
            if (jMenuItem == null || !jMenuItem.getActionCommand().equals("savegifanim")) continue;
            jMenuItem.setEnabled(bl);
            return;
        }
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.view != null) {
            this.view.dispose();
            this.view = null;
        }
    }
}

