/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionUser;

public class JMLPosition {
    static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    protected double x;
    protected double y;
    protected double z;
    protected double t;
    protected double angle;
    protected int juggler;
    protected JMLPosition prev = null;
    protected JMLPosition next = null;

    public Coordinate getCoordinate() {
        return new Coordinate(this.x, this.y, this.z);
    }

    public void setCoordinate(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
        this.z = coordinate.z;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getT() {
        return this.t;
    }

    public void setT(double d) {
        this.t = d;
    }

    public int getJuggler() {
        return this.juggler;
    }

    public void setJuggler(String string) throws JuggleExceptionUser {
        this.juggler = Integer.parseInt(string);
    }

    public void setJuggler(int n) {
        this.juggler = n;
    }

    public JMLPosition getPrevious() {
        return this.prev;
    }

    public void setPrevious(JMLPosition jMLPosition) {
        this.prev = jMLPosition;
    }

    public JMLPosition getNext() {
        return this.next;
    }

    public void setNext(JMLPosition jMLPosition) {
        this.next = jMLPosition;
    }

    public void readJML(JMLNode jMLNode, String string) throws JuggleExceptionUser {
        JMLAttributes jMLAttributes = jMLNode.getAttributes();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        String string2 = "1";
        try {
            for (int i = 0; i < jMLAttributes.getNumberOfAttributes(); ++i) {
                if (jMLAttributes.getAttributeName(i).equalsIgnoreCase("x")) {
                    d = Double.valueOf(jMLAttributes.getAttributeValue(i));
                    continue;
                }
                if (jMLAttributes.getAttributeName(i).equalsIgnoreCase("y")) {
                    d2 = Double.valueOf(jMLAttributes.getAttributeValue(i));
                    continue;
                }
                if (jMLAttributes.getAttributeName(i).equalsIgnoreCase("z")) {
                    d3 = Double.valueOf(jMLAttributes.getAttributeValue(i));
                    continue;
                }
                if (jMLAttributes.getAttributeName(i).equalsIgnoreCase("t")) {
                    d4 = Double.valueOf(jMLAttributes.getAttributeValue(i));
                    continue;
                }
                if (jMLAttributes.getAttributeName(i).equalsIgnoreCase("angle")) {
                    d5 = Double.valueOf(jMLAttributes.getAttributeValue(i));
                    continue;
                }
                if (!jMLAttributes.getAttributeName(i).equalsIgnoreCase("juggler")) continue;
                string2 = jMLAttributes.getAttributeValue(i);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_position_coordinate"));
        }
        this.setCoordinate(new Coordinate(d, d2, d3));
        this.setT(d4);
        this.setAngle(d5);
        if (string2 == null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_position_nojuggler"));
        }
        this.setJuggler(string2);
        if (jMLNode.getNumberOfChildren() != 0) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_position_subtag"));
        }
    }

    public void writeJML(PrintWriter printWriter) throws IOException {
        Coordinate coordinate = this.getCoordinate();
        printWriter.println("<position x=\"" + JMLPattern.toStringTruncated(coordinate.x, 4) + "\" y=\"" + JMLPattern.toStringTruncated(coordinate.y, 4) + "\" z=\"" + JMLPattern.toStringTruncated(coordinate.z, 4) + "\" t=\"" + JMLPattern.toStringTruncated(this.getT(), 4) + "\" angle=\"" + JMLPattern.toStringTruncated(this.getAngle(), 4) + "\" juggler=\"" + Integer.toString(this.getJuggler()) + "\"/>");
    }
}

