/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jugglinglab.core.AnimatorPrefs;
import jugglinglab.core.PatternList;
import jugglinglab.core.PatternListWindow;
import jugglinglab.core.PatternWindow;
import jugglinglab.generator.Generator;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.jml.JMLPattern;
import jugglinglab.notation.Notation;
import jugglinglab.notation.NotationControl;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionDone;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.LabelDialog;
import jugglinglab.view.View;

public class NotationGUI
extends JPanel
implements ActionListener {
    static ResourceBundle guistrings = JLLocale.getBundle("GUIStrings");
    static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    protected JTabbedPane jtp = null;
    protected JFrame parent = null;
    protected View animtarget = null;
    protected PatternList patlist = null;
    protected boolean patlisttab = false;
    protected int currentnum = -1;
    protected JButton juggle = null;
    protected JButton run = null;
    protected JLabel busy = null;
    protected static final int max_patterns = 1000;
    protected static final double max_time = 15.0;
    protected static final String[] helpItems = new String[]{"About Juggling Lab"};
    protected static final String[] helpCommands = new String[]{"about"};
    public static final int HELP_NONE = 0;
    public static final int HELP_ABOUT = 1;

    public NotationGUI(JFrame jFrame) throws JuggleExceptionInternal {
        this(jFrame, null, null, false);
    }

    public NotationGUI(JFrame jFrame, View view, PatternList patternList, boolean bl) {
        this.parent = jFrame;
        this.animtarget = view;
        this.patlist = patternList;
        this.patlisttab = patternList == null ? bl : true;
    }

    public JButton getDefaultButton() {
        if (this.jtp == null) {
            return null;
        }
        if (this.jtp.getSelectedIndex() == 0) {
            return this.juggle;
        }
        return this.run;
    }

    public JMenu createNotationMenu() {
        JMenu jMenu = new JMenu(guistrings.getString("Notation"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < Notation.builtinNotations.length; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(Notation.builtinNotations[i]);
            jRadioButtonMenuItem.setActionCommand("notation" + (i + 1));
            jRadioButtonMenuItem.addActionListener(this);
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    public JMenu createHelpMenu(boolean bl) {
        int n;
        if (!bl) {
            return null;
        }
        JMenu jMenu = new JMenu(guistrings.getString("Help"));
        int n2 = n = bl ? 0 : 1;
        while (n < helpItems.length) {
            if (helpItems[n] == null) {
                jMenu.addSeparator();
            } else {
                JMenuItem jMenuItem = new JMenuItem(guistrings.getString(helpItems[n].replace(' ', '_')));
                jMenuItem.setActionCommand(helpCommands[n]);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
            ++n;
        }
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            String string = actionEvent.getActionCommand();
            try {
                if (string.startsWith("notation")) {
                    try {
                        int n = Integer.parseInt(string.substring(8));
                        if (n != this.currentnum) {
                            this.setNotation(n);
                            if (this.parent != null) {
                                this.parent.pack();
                            }
                            this.currentnum = n;
                        }
                        break block8;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JuggleExceptionInternal("Error in notation number coding");
                    }
                }
                if (string.equals("about")) {
                    this.doMenuCommand(1);
                }
            }
            catch (Exception exception) {
                ErrorDialog.handleException(exception);
            }
        }
    }

    public void doMenuCommand(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.showAboutBox();
            }
        }
    }

    public void setNotation(int n) throws JuggleExceptionUser, JuggleExceptionInternal {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        if (n > Notation.builtinNotations.length) {
            return;
        }
        Notation notation = null;
        NotationControl notationControl = null;
        if (n != 0) {
            try {
                notation = Notation.getNotation(Notation.builtinNotations[n - 1]);
                serializable2 = Class.forName("jugglinglab.notation." + Notation.builtinNotations[n - 1].toLowerCase() + "NotationControl");
                notationControl = (NotationControl)((Class)serializable2).newInstance();
            }
            catch (JuggleExceptionUser juggleExceptionUser) {
                throw new JuggleExceptionInternal("Could not create notation \"" + Notation.builtinNotations[n - 1] + "\"");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JuggleExceptionUser("Could not find " + Notation.builtinNotations[n - 1].toLowerCase() + "NotationControl class");
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        if (this.jtp != null) {
            this.remove(this.jtp);
        }
        this.jtp = new JTabbedPane();
        serializable2 = this.patlist;
        if (notationControl != null) {
            object = notation;
            serializable = notationControl;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)notationControl, "First");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(4));
            JButton jButton = new JButton(guistrings.getString("Defaults"));
            jButton.addActionListener(new ActionListener((NotationControl)serializable){
                final /* synthetic */ NotationControl val$fcontrol;
                {
                    this.val$fcontrol = notationControl;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        this.val$fcontrol.resetNotationControl();
                    }
                    catch (Exception exception) {
                        ErrorDialog.handleException(exception);
                    }
                }
            });
            jPanel2.add(jButton);
            this.juggle = new JButton(guistrings.getString("Juggle"));
            this.juggle.setDefaultCapable(true);
            this.juggle.addActionListener(new ActionListener((NotationControl)serializable, (Notation)object){
                final /* synthetic */ NotationControl val$fcontrol;
                final /* synthetic */ Notation val$fnot;
                {
                    this.val$fcontrol = notationControl;
                    this.val$fnot = notation;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PatternWindow patternWindow = null;
                    try {
                        String string = this.val$fcontrol.getPattern();
                        JMLPattern jMLPattern = this.val$fnot.getJMLPattern(string);
                        String string2 = this.val$fcontrol.getHandsName();
                        if (string2 != null) {
                            jMLPattern.setTitle(jMLPattern.getTitle() + " " + string2);
                        }
                        if (NotationGUI.this.animtarget != null) {
                            NotationGUI.this.animtarget.restartView(jMLPattern, new AnimatorPrefs());
                        } else {
                            patternWindow = new PatternWindow(jMLPattern.getTitle(), jMLPattern, new AnimatorPrefs());
                        }
                    }
                    catch (JuggleExceptionUser juggleExceptionUser) {
                        if (patternWindow != null) {
                            patternWindow.dispose();
                        }
                        new ErrorDialog(NotationGUI.this, juggleExceptionUser.getMessage());
                    }
                    catch (Exception exception) {
                        if (patternWindow != null) {
                            patternWindow.dispose();
                        }
                        ErrorDialog.handleException(exception);
                    }
                }
            });
            jPanel2.add(this.juggle);
            jPanel.add((Component)jPanel2, "Last");
            this.jtp.addTab(guistrings.getString("Pattern_entry"), jPanel);
            final Generator generator = Generator.getGenerator(Notation.builtinNotations[n - 1]);
            if (generator != null) {
                if (serializable2 == null && this.patlisttab) {
                    serializable2 = new PatternList(this.animtarget);
                }
                Serializable serializable3 = serializable2;
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(new BorderLayout());
                jPanel3.add((Component)generator.getGeneratorControls(), "First");
                JPanel jPanel4 = new JPanel();
                jPanel4.setLayout(new FlowLayout(4));
                JButton jButton2 = new JButton(guistrings.getString("Defaults"));
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        generator.resetGeneratorControls();
                    }
                });
                jPanel4.add(jButton2);
                this.run = new JButton(guistrings.getString("Run"));
                this.run.addActionListener(new ActionListener((PatternList)serializable3, (Notation)object){
                    final /* synthetic */ PatternList val$plf;
                    final /* synthetic */ Notation val$fnot;
                    {
                        this.val$plf = patternList;
                        this.val$fnot = notation;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Thread thread = new Thread(){

                            public void run() {
                                NotationGUI.this.busy.setVisible(true);
                                NotationGUI.this.run.setEnabled(false);
                                Window window = null;
                                try {
                                    generator.initGenerator();
                                    GeneratorTarget generatorTarget = null;
                                    if (val$plf != null) {
                                        val$plf.clearList();
                                        generatorTarget = new GeneratorTarget(val$plf);
                                    } else {
                                        window = new PatternListWindow(val$fnot.getName() + " " + guistrings.getString("Patterns"));
                                        generatorTarget = new GeneratorTarget((PatternListWindow)window);
                                    }
                                    generator.runGenerator(generatorTarget, 1000, 15.0);
                                    if (val$plf != null) {
                                        NotationGUI.this.jtp.setSelectedComponent(val$plf);
                                    }
                                }
                                catch (JuggleExceptionDone juggleExceptionDone) {
                                    if (val$plf != null) {
                                        NotationGUI.this.jtp.setSelectedComponent(val$plf);
                                    }
                                    Container container = window;
                                    if (window == null) {
                                        container = val$plf;
                                    }
                                    new LabelDialog(container, guistrings.getString("Generator_stopped_title"), juggleExceptionDone.getMessage());
                                }
                                catch (JuggleExceptionUser juggleExceptionUser) {
                                    if (window != null) {
                                        window.dispose();
                                    }
                                    new ErrorDialog(NotationGUI.this, juggleExceptionUser.getMessage());
                                }
                                catch (Exception exception) {
                                    if (window != null) {
                                        window.dispose();
                                    }
                                    ErrorDialog.handleException(exception);
                                }
                                NotationGUI.this.busy.setVisible(false);
                                NotationGUI.this.run.setEnabled(true);
                            }
                        };
                        thread.start();
                    }
                });
                jPanel4.add(this.run);
                this.busy = new JLabel(guistrings.getString("Processing"));
                this.busy.setVisible(false);
                JPanel jPanel5 = new JPanel();
                jPanel5.setLayout(new BorderLayout());
                JPanel jPanel6 = new JPanel();
                GridBagLayout gridBagLayout = new GridBagLayout();
                jPanel6.setLayout(gridBagLayout);
                jPanel6.add(this.busy);
                gridBagLayout.setConstraints(this.busy, NotationGUI.make_constraints(21, 0, 0, new Insets(0, 10, 0, 0)));
                jPanel5.add((Component)jPanel6, "Before");
                jPanel5.add((Component)jPanel4, "After");
                jPanel3.add((Component)jPanel5, "Last");
                this.jtp.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        NotationGUI.this.getRootPane().setDefaultButton(NotationGUI.this.getDefaultButton());
                    }
                });
                this.jtp.addTab(guistrings.getString("Generator"), jPanel3);
            }
        }
        if (serializable2 != null) {
            this.jtp.addTab(guistrings.getString("Pattern_list_tab"), (Component)serializable2);
            if (this.patlist != null) {
                this.jtp.setSelectedComponent((Component)serializable2);
            }
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.jtp, "Center");
        object = new GridBagLayout();
        this.setLayout((LayoutManager)object);
        this.add(this.jtp);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).anchor = 21;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagLayout)object).setConstraints(this.jtp, (GridBagConstraints)serializable);
        if (this.parent != null) {
            this.parent.getRootPane().setDefaultButton(this.getDefaultButton());
        }
    }

    protected void showAboutBox() {
        Serializable serializable;
        Accessible accessible;
        final JFrame jFrame = new JFrame(guistrings.getString("About_Juggling_Lab"));
        jFrame.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jFrame.getContentPane().add((Component)jPanel, "Center");
        URL uRL = this.getClass().getResource("/resources/about.gif");
        if (uRL != null && (accessible = new ImageIcon(uRL, "A lab")) != null) {
            serializable = new JLabel((Icon)((Object)accessible));
            jPanel.add((Component)serializable, "Before");
        }
        accessible = new JPanel();
        jPanel.add((Component)((Object)accessible), "After");
        serializable = new GridBagLayout();
        ((Container)((Object)accessible)).setLayout((LayoutManager)((Object)serializable));
        JLabel jLabel = new JLabel("Juggling Lab");
        jLabel.setFont(new Font("SansSerif", 1, 18));
        ((Container)((Object)accessible)).add(jLabel);
        ((GridBagLayout)serializable).setConstraints(jLabel, NotationGUI.make_constraints(21, 0, 0, new Insets(15, 15, 0, 15)));
        String string = guistrings.getString("Version");
        Object[] objectArray = new Object[]{"0.6.2"};
        JLabel jLabel2 = new JLabel(MessageFormat.format(string, objectArray));
        jLabel2.setFont(new Font("SansSerif", 0, 12));
        ((Container)((Object)accessible)).add(jLabel2);
        ((GridBagLayout)serializable).setConstraints(jLabel2, NotationGUI.make_constraints(21, 0, 1, new Insets(0, 15, 0, 15)));
        String string2 = guistrings.getString("Copyright_message");
        Object[] objectArray2 = new Object[]{"2014"};
        JLabel jLabel3 = new JLabel(MessageFormat.format(string2, objectArray2));
        jLabel3.setFont(new Font("SansSerif", 0, 10));
        ((Container)((Object)accessible)).add(jLabel3);
        ((GridBagLayout)serializable).setConstraints(jLabel3, NotationGUI.make_constraints(21, 0, 2, new Insets(15, 15, 15, 15)));
        JLabel jLabel4 = new JLabel(guistrings.getString("GPL_message"));
        jLabel4.setFont(new Font("SansSerif", 0, 10));
        ((Container)((Object)accessible)).add(jLabel4);
        ((GridBagLayout)serializable).setConstraints(jLabel4, NotationGUI.make_constraints(21, 0, 3, new Insets(0, 15, 0, 15)));
        JButton jButton = new JButton(guistrings.getString("OK"));
        ((Container)((Object)accessible)).add(jButton);
        ((GridBagLayout)serializable).setConstraints(jButton, NotationGUI.make_constraints(22, 0, 4, new Insets(15, 15, 15, 15)));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        Locale locale = JLLocale.getLocale();
        jFrame.applyComponentOrientation(ComponentOrientation.getOrientation(locale));
        jFrame.pack();
        jFrame.setResizable(false);
        jFrame.setVisible(true);
    }

    protected static GridBagConstraints make_constraints(int n, int n2, int n3, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        return gridBagConstraints;
    }
}

