/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jugglinglab.notation.NotationControl;
import jugglinglab.notation.mhnPattern;
import jugglinglab.prop.Prop;

public class mhnNotationControl
extends NotationControl {
    protected static final String[] builtinHandsNames = new String[]{"inside", "outside", "half", "Mills"};
    protected static final String[] builtinHandsStrings = new String[]{"(10)(32.5).", "(32.5)(10).", "(32.5)(10).(10)(32.5).", "(-25)(2.5).(25)(-2.5).(-25)(0)."};
    protected static final String[] builtinBodyNames = new String[]{"line", "feed", "backtoback", "sidetoside", "circles"};
    protected static final String[] builtinBodyStrings = new String[]{"<(90).|(270,-125).|(90,125).|(270,-250).|(90,250).|(270,-375).>", "<(90,75).|(270,-75,50).|(270,-75,-50).|(270,-75,150).|(270,-75,-150).>", "<(270,35).|(90,-35).|(0,0,35).|(180,0,-35).>", "<(0).|(0,100).|(0,-100).|(0,200).|(0,-200).|(0,300).>", "(0,75,0)...(90,0,75)...(180,-75,0)...(270,0,-75)..."};
    protected JTextField tf1;
    protected JTextField tf2;
    protected JTextField tf3;
    protected JTextField tf4;
    protected JTextField tf5;
    protected JTextField tf6;
    protected JComboBox cb1;
    protected JComboBox cb2;
    protected JComboBox cb3;
    protected boolean cb1_selected = false;
    protected boolean cb2_selected = false;
    protected static final int border = 10;
    protected static final int hspacing = 5;
    protected static final int vspacing = 12;

    public mhnNotationControl() {
        Object object;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(guistrings.getString("Pattern"));
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jLabel, mhnNotationControl.make_constraints(22, 0, 0, new Insets(10, 10, 0, 5)));
        this.tf1 = new JTextField(15);
        jPanel.add(this.tf1);
        gridBagLayout.setConstraints(this.tf1, mhnNotationControl.make_constraints(21, 1, 0, new Insets(10, 0, 0, 10)));
        JLabel jLabel2 = new JLabel(guistrings.getString("Beats_per_second"));
        jPanel.add(jLabel2);
        gridBagLayout.setConstraints(jLabel2, mhnNotationControl.make_constraints(22, 0, 1, new Insets(24, 10, 0, 5)));
        this.tf3 = new JTextField(4);
        jPanel.add(this.tf3);
        gridBagLayout.setConstraints(this.tf3, mhnNotationControl.make_constraints(21, 1, 1, new Insets(24, 0, 0, 10)));
        JLabel jLabel3 = new JLabel(guistrings.getString("Dwell_beats"));
        jPanel.add(jLabel3);
        gridBagLayout.setConstraints(jLabel3, mhnNotationControl.make_constraints(22, 0, 2, new Insets(12, 10, 0, 5)));
        this.tf2 = new JTextField(4);
        jPanel.add(this.tf2);
        gridBagLayout.setConstraints(this.tf2, mhnNotationControl.make_constraints(21, 1, 2, new Insets(12, 0, 0, 10)));
        JLabel jLabel4 = new JLabel(guistrings.getString("Hand_movement"));
        jPanel.add(jLabel4);
        gridBagLayout.setConstraints(jLabel4, mhnNotationControl.make_constraints(22, 0, 3, new Insets(12, 10, 0, 5)));
        this.cb1 = new JComboBox();
        this.cb1.addItem(guistrings.getString("MHNHands_name_default"));
        for (int i = 0; i < builtinHandsNames.length; ++i) {
            String string = "MHNHands_name_" + builtinHandsNames[i];
            this.cb1.addItem(guistrings.getString(string));
        }
        this.cb1.addItem(guistrings.getString("MHNHands_name_custom"));
        jPanel.add(this.cb1);
        gridBagLayout.setConstraints(this.cb1, mhnNotationControl.make_constraints(21, 1, 3, new Insets(12, 0, 0, 10)));
        this.tf4 = new JTextField(15);
        jPanel.add(this.tf4);
        gridBagLayout.setConstraints(this.tf4, mhnNotationControl.make_constraints(21, 1, 4, new Insets(5, 0, 0, 10)));
        this.cb1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = mhnNotationControl.this.cb1.getSelectedIndex();
                mhnNotationControl.this.cb1_selected = true;
                if (n == 0) {
                    mhnNotationControl.this.tf4.setText("");
                    mhnNotationControl.this.tf4.setEnabled(false);
                } else if (n == builtinHandsNames.length + 1) {
                    mhnNotationControl.this.tf4.setEnabled(true);
                } else {
                    mhnNotationControl.this.tf4.setText(builtinHandsStrings[n - 1]);
                    mhnNotationControl.this.tf4.setCaretPosition(0);
                    mhnNotationControl.this.tf4.setEnabled(true);
                }
            }
        });
        this.tf4.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!mhnNotationControl.this.cb1_selected) {
                    mhnNotationControl.this.cb1.setSelectedIndex(builtinHandsNames.length + 1);
                }
                mhnNotationControl.this.cb1_selected = false;
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!mhnNotationControl.this.cb1_selected) {
                    mhnNotationControl.this.cb1.setSelectedIndex(builtinHandsNames.length + 1);
                }
            }
        });
        JLabel jLabel5 = new JLabel(guistrings.getString("Body_movement"));
        jPanel.add(jLabel5);
        gridBagLayout.setConstraints(jLabel5, mhnNotationControl.make_constraints(22, 0, 5, new Insets(12, 10, 0, 5)));
        this.cb2 = new JComboBox();
        this.cb2.addItem(guistrings.getString("MHNBody_name_default"));
        for (int i = 0; i < builtinBodyNames.length; ++i) {
            String string = "MHNBody_name_" + builtinBodyNames[i];
            this.cb2.addItem(guistrings.getString(string));
        }
        this.cb2.addItem(guistrings.getString("MHNBody_name_custom"));
        jPanel.add(this.cb2);
        gridBagLayout.setConstraints(this.cb2, mhnNotationControl.make_constraints(21, 1, 5, new Insets(12, 0, 0, 10)));
        this.tf5 = new JTextField(15);
        jPanel.add(this.tf5);
        gridBagLayout.setConstraints(this.tf5, mhnNotationControl.make_constraints(21, 1, 6, new Insets(5, 0, 0, 10)));
        this.cb2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = mhnNotationControl.this.cb2.getSelectedIndex();
                mhnNotationControl.this.cb2_selected = true;
                if (n == 0) {
                    mhnNotationControl.this.tf5.setText("");
                    mhnNotationControl.this.tf5.setEnabled(false);
                } else if (n == builtinBodyNames.length + 1) {
                    mhnNotationControl.this.tf5.setEnabled(true);
                } else {
                    mhnNotationControl.this.tf5.setText(builtinBodyStrings[n - 1]);
                    mhnNotationControl.this.tf5.setCaretPosition(0);
                    mhnNotationControl.this.tf5.setEnabled(true);
                }
            }
        });
        this.tf5.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                if (!mhnNotationControl.this.cb2_selected) {
                    mhnNotationControl.this.cb2.setSelectedIndex(builtinBodyNames.length + 1);
                }
                mhnNotationControl.this.cb2_selected = false;
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (!mhnNotationControl.this.cb2_selected) {
                    mhnNotationControl.this.cb2.setSelectedIndex(builtinBodyNames.length + 1);
                }
            }
        });
        JLabel jLabel6 = new JLabel(guistrings.getString("Prop_type"));
        jPanel.add(jLabel6);
        gridBagLayout.setConstraints(jLabel6, mhnNotationControl.make_constraints(22, 0, 7, new Insets(12, 10, 0, 5)));
        this.cb3 = new JComboBox();
        for (int i = 0; i < Prop.builtinProps.length; ++i) {
            object = "Prop_name_" + Prop.builtinProps[i].toLowerCase();
            this.cb3.addItem(guistrings.getString((String)object));
        }
        jPanel.add(this.cb3);
        gridBagLayout.setConstraints(this.cb3, mhnNotationControl.make_constraints(21, 1, 7, new Insets(12, 0, 0, 10)));
        JLabel jLabel7 = new JLabel(guistrings.getString("Manual_settings"));
        jPanel.add(jLabel7);
        gridBagLayout.setConstraints(jLabel7, mhnNotationControl.make_constraints(21, 0, 8, new Insets(24, 10, 0, 5)));
        this.tf6 = new JTextField(25);
        jPanel.add(this.tf6);
        object = mhnNotationControl.make_constraints(22, 0, 9, new Insets(5, 15, 0, 10));
        ((GridBagConstraints)object).gridwidth = 2;
        gridBagLayout.setConstraints(this.tf6, (GridBagConstraints)object);
        this.resetNotationControl();
        this.add((Component)jPanel, "First");
    }

    protected static GridBagConstraints make_constraints(int n, int n2, int n3) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        return gridBagConstraints;
    }

    protected static GridBagConstraints make_constraints(int n, int n2, int n3, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        return gridBagConstraints;
    }

    public String getPattern() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("pattern=");
        stringBuffer.append(this.tf1.getText());
        stringBuffer.append(";prop=" + Prop.builtinProps[this.cb3.getSelectedIndex()].toLowerCase());
        if (this.tf2.getText().length() > 0 && !this.tf2.getText().equals(new Double(mhnPattern.dwell_default).toString())) {
            stringBuffer.append(";dwell=");
            stringBuffer.append(this.tf2.getText());
        }
        if (this.tf3.getText().length() > 0) {
            stringBuffer.append(";bps=");
            stringBuffer.append(this.tf3.getText());
        }
        if (this.tf4.getText().length() > 0) {
            stringBuffer.append(";hands=");
            stringBuffer.append(this.tf4.getText());
        }
        if (this.tf5.getText().length() > 0) {
            stringBuffer.append(";body=");
            stringBuffer.append(this.tf5.getText());
        }
        if (this.tf6.getText().length() > 0) {
            stringBuffer.append(";");
            stringBuffer.append(this.tf6.getText());
        }
        return stringBuffer.toString();
    }

    public void resetNotationControl() {
        this.tf1.setText("3");
        this.tf2.setText(new Double(mhnPattern.dwell_default).toString());
        this.tf3.setText("");
        this.tf4.setText("");
        this.cb1.setSelectedIndex(0);
        this.tf5.setText("");
        this.cb2.setSelectedIndex(0);
        this.tf6.setText("");
        this.cb3.setSelectedIndex(0);
    }

    public String getHandsName() {
        int n = this.cb1.getSelectedIndex();
        if (n == 0 || n == builtinHandsNames.length + 1) {
            return null;
        }
        return builtinHandsNames[n - 1];
    }
}

