/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.Vector;
import jugglinglab.notation.ParseException;
import jugglinglab.notation.SiteswapParser;
import jugglinglab.notation.SiteswapTreeItem;
import jugglinglab.notation.TokenMgrError;
import jugglinglab.notation.mhnHands;
import jugglinglab.notation.mhnPattern;
import jugglinglab.notation.mhnSymmetry;
import jugglinglab.notation.mhnThrow;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;

public class siteswapPattern
extends mhnPattern {
    protected boolean oddperiod = false;
    boolean[] right_on_even;

    protected int getNorepPeriod() {
        return this.oddperiod ? this.getPeriod() / 2 : this.getPeriod();
    }

    public void parseInput(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (string.indexOf(61) == -1) {
            this.pattern = string;
        } else {
            super.parseInput(string);
            this.parseLegacyParameters(string);
        }
    }

    protected void parseLegacyParameters(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        double d;
        ParameterList parameterList = new ParameterList(string);
        String string2 = null;
        double d2 = 0.2;
        double d3 = 0.5;
        double d4 = 0.2;
        double d5 = 0.5;
        boolean bl = false;
        string2 = parameterList.getParameter("tps");
        if (string2 != null) {
            try {
                this.bps = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("dratio")) != null) {
            try {
                d = Double.valueOf(string2);
                if (d > 0.0 && d < 1.9) {
                    this.dwell = 2.0 * d;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("throwx")) != null) {
            try {
                d2 = d4 = (d = Double.valueOf(string2).doubleValue());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("rightthrowx")) != null) {
            try {
                d2 = d = Double.valueOf(string2).doubleValue();
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("leftthrowx")) != null) {
            try {
                d4 = d = Double.valueOf(string2).doubleValue();
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("catchx")) != null) {
            try {
                d3 = d5 = (d = Double.valueOf(string2).doubleValue());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("rightcatchx")) != null) {
            try {
                d3 = d = Double.valueOf(string2).doubleValue();
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("leftcatchx")) != null) {
            try {
                d5 = d = Double.valueOf(string2).doubleValue();
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("balldiam")) != null) {
            try {
                this.propdiam = 100.0 * Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("g")) != null) {
            try {
                this.gravity = 100.0 * Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = parameterList.getParameter("mat_style")) != null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_unsupported_setting") + ": 'mat_style'");
        }
        string2 = parameterList.getParameter("mat_DR");
        if (string2 != null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_unsupported_setting") + ": 'mat_DR'");
        }
        string2 = parameterList.getParameter("mat_HR");
        if (string2 != null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_unsupported_setting") + ": 'mat_HR'");
        }
        if (this.hands == null && bl) {
            this.hands = new mhnHands("(" + 100.0 * d2 + ")(" + 100.0 * d3 + ").(" + 100.0 * d4 + ")(" + 100.0 * d5 + ").");
        }
    }

    public void parsePattern() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.th = null;
        this.symmetry = new Vector();
        SiteswapTreeItem siteswapTreeItem = null;
        try {
            siteswapTreeItem = SiteswapParser.parsePattern(this.pattern);
        }
        catch (ParseException parseException) {
            String string = errorstrings.getString("Error_pattern_syntax");
            String string2 = ParseException.add_escapes(parseException.currentToken.next.image);
            Object[] objectArray = new Object[]{string2, new Integer(parseException.currentToken.next.beginColumn)};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        catch (TokenMgrError tokenMgrError) {
            String string = errorstrings.getString("Error_pattern_syntax");
            String string3 = TokenMgrError.addEscapes(String.valueOf(tokenMgrError.curChar));
            Object[] objectArray = new Object[]{string3, new Integer(tokenMgrError.errorColumn - 1)};
            throw new JuggleExceptionUser(MessageFormat.format(string, objectArray));
        }
        this.numjugglers = siteswapTreeItem.jugglers;
        this.max_occupancy = 0;
        this.max_throw = 0;
        this.right_on_even = new boolean[this.numjugglers];
        for (int i = 0; i < this.numjugglers; ++i) {
            this.right_on_even[i] = true;
        }
        siteswapTreeItem.beatnum = 0;
        this.doFirstPass(siteswapTreeItem);
        if (!siteswapTreeItem.switchrepeat && siteswapTreeItem.vanilla_asynch && siteswapTreeItem.beats % 2 == 1) {
            siteswapTreeItem.switchrepeat = true;
            siteswapTreeItem.beats *= 2;
            siteswapTreeItem.throw_sum *= 2;
            this.oddperiod = true;
        }
        this.period = siteswapTreeItem.beats;
        if (siteswapTreeItem.throw_sum % siteswapTreeItem.beats != 0) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_siteswap_bad_average"));
        }
        this.numpaths = siteswapTreeItem.throw_sum / siteswapTreeItem.beats;
        this.indexes = this.max_throw + this.period + 1;
        this.th = new mhnThrow[this.numjugglers][2][this.indexes][this.max_occupancy];
        this.doSecondPass(siteswapTreeItem, false, 0);
        this.addSymmetry(new mhnSymmetry(1, this.numjugglers, null, this.period));
        if (siteswapTreeItem.switchrepeat) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i <= this.numjugglers; ++i) {
                stringBuffer.append("(" + i + "," + i + "*)");
            }
            this.addSymmetry(new mhnSymmetry(3, this.numjugglers, stringBuffer.toString(), this.period / 2));
        }
        if (this.bodies != null && this.bodies.getNumberOfJugglers() < this.getNumberOfJugglers()) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_jugglers_body"));
        }
    }

    protected int[][] findExitState(SiteswapTreeItem[] siteswapTreeItemArray) {
        return null;
    }

    protected int[][] findEntranceState(SiteswapTreeItem[] siteswapTreeItemArray) {
        return null;
    }

    protected SiteswapTreeItem findShortestTransition(int[][] nArray, int[][] nArray2, int n, boolean bl) {
        return null;
    }

    protected void doFirstPass(SiteswapTreeItem siteswapTreeItem) throws JuggleExceptionUser, JuggleExceptionInternal {
        SiteswapTreeItem siteswapTreeItem2 = null;
        siteswapTreeItem.throw_sum = 0;
        siteswapTreeItem.vanilla_asynch = true;
        switch (siteswapTreeItem.type) {
            case 1: {
                siteswapTreeItem.beats = 0;
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum + siteswapTreeItem.beats;
                    if (siteswapTreeItem2.type == 13) {
                        Object object;
                        int n;
                        int n2;
                        int n3;
                        siteswapTreeItem2.transition = null;
                        SiteswapTreeItem[] siteswapTreeItemArray = new SiteswapTreeItem[siteswapTreeItem.getNumberOfChildren()];
                        int n4 = siteswapTreeItem.getNumberOfChildren() - 1;
                        boolean bl = false;
                        for (n3 = i - 1; n3 >= 0; --n3) {
                            siteswapTreeItemArray[n4--] = siteswapTreeItem.getChild(n3);
                            if (siteswapTreeItem.getChild((int)n3).type == 2) {
                                bl = true;
                                break;
                            }
                            if (siteswapTreeItem.getChild((int)n3).type != 13) continue;
                            throw new JuggleExceptionUser("Can only have one wildcard between grouped patterns");
                        }
                        if (!bl) {
                            n3 = 0;
                            for (n2 = siteswapTreeItem.getNumberOfChildren() - 1; n2 > i; --n2) {
                                SiteswapTreeItem siteswapTreeItem3 = siteswapTreeItem.getChild(n2);
                                siteswapTreeItemArray[n4--] = siteswapTreeItem3;
                                if (siteswapTreeItem3.type == 2) {
                                    bl = true;
                                    break;
                                }
                                if (siteswapTreeItem3.type != 13) continue;
                                throw new JuggleExceptionUser("Can only have one wildcard between grouped patterns");
                            }
                        }
                        if (!bl) {
                            throw new JuggleExceptionUser("Must have at least one grouped subpattern to use wildcard");
                        }
                        SiteswapTreeItem[] siteswapTreeItemArray2 = new SiteswapTreeItem[siteswapTreeItem.getNumberOfChildren() - 1 - n4];
                        ++n4;
                        n2 = 0;
                        while (n4 < siteswapTreeItem.getNumberOfChildren()) {
                            siteswapTreeItemArray2[n2] = siteswapTreeItemArray[n4];
                            ++n2;
                            ++n4;
                        }
                        for (n2 = siteswapTreeItemArray2.length; n2 >= 0; --n2) {
                        }
                        int[][] nArray = this.findExitState(siteswapTreeItemArray2);
                        n4 = 0;
                        bl = false;
                        for (n = i + 1; n < siteswapTreeItem.getNumberOfChildren(); ++n) {
                            siteswapTreeItemArray[n4++] = siteswapTreeItem.getChild(n);
                            if (siteswapTreeItem.getChild((int)n).type == 2) {
                                bl = true;
                                break;
                            }
                            if (siteswapTreeItem.getChild((int)n).type != 13) continue;
                            throw new JuggleExceptionUser("Can only have one wildcard between grouped patterns");
                        }
                        if (!bl) {
                            for (n = 0; n < i; ++n) {
                                object = siteswapTreeItem.getChild(n);
                                siteswapTreeItemArray[n4++] = object;
                                if (((SiteswapTreeItem)object).type == 2) {
                                    bl = true;
                                    break;
                                }
                                if (((SiteswapTreeItem)object).type != 13) continue;
                                throw new JuggleExceptionUser("Can only have one wildcard between grouped patterns");
                            }
                        }
                        if (!bl) {
                            throw new JuggleExceptionUser("Must have at least one grouped subpattern to use wildcard");
                        }
                        siteswapTreeItemArray2 = new SiteswapTreeItem[n4];
                        for (n = 0; n < n4; ++n) {
                            siteswapTreeItemArray2[n] = siteswapTreeItemArray[n];
                        }
                        for (n = 0; n < 2; ++n) {
                            for (int j = 0; j < siteswapTreeItemArray2.length; ++j) {
                            }
                            object = this.findEntranceState(siteswapTreeItemArray2);
                        }
                    }
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.beats += siteswapTreeItem2.beats;
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                    siteswapTreeItem.vanilla_asynch &= siteswapTreeItem2.vanilla_asynch;
                }
                if (!siteswapTreeItem.switchrepeat) break;
                siteswapTreeItem.beats *= 2;
                siteswapTreeItem.throw_sum *= 2;
                break;
            }
            case 2: {
                siteswapTreeItem2 = siteswapTreeItem.getChild(0);
                if (siteswapTreeItem.getNumberOfChildren() > 1) {
                    siteswapTreeItem.removeChildren();
                    siteswapTreeItem.addChild(siteswapTreeItem2);
                }
                siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                this.doFirstPass(siteswapTreeItem2);
                for (int i = 1; i < siteswapTreeItem.repeats; ++i) {
                    SiteswapTreeItem siteswapTreeItem4 = (SiteswapTreeItem)siteswapTreeItem2.clone();
                    siteswapTreeItem.addChild(siteswapTreeItem4);
                    siteswapTreeItem4.beatnum = siteswapTreeItem.beatnum + i * siteswapTreeItem2.beats;
                    this.doFirstPass(siteswapTreeItem4);
                }
                siteswapTreeItem.beats = siteswapTreeItem2.beats * siteswapTreeItem.repeats;
                siteswapTreeItem.throw_sum = siteswapTreeItem2.throw_sum * siteswapTreeItem.repeats;
                siteswapTreeItem.vanilla_asynch &= siteswapTreeItem2.vanilla_asynch;
                break;
            }
            case 3: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum + siteswapTreeItem2.seq_beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                    siteswapTreeItem.vanilla_asynch &= siteswapTreeItem2.vanilla_asynch;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem2.left = i == 0;
                    siteswapTreeItem2.synch_throw = true;
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                }
                siteswapTreeItem.vanilla_asynch = false;
                break;
            }
            case 5: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.value;
                }
                siteswapTreeItem.left = siteswapTreeItem.beatnum % 2 == 0 ? !this.right_on_even[siteswapTreeItem.source_juggler - 1] : this.right_on_even[siteswapTreeItem.source_juggler - 1];
                if (siteswapTreeItem.getNumberOfChildren() <= this.max_occupancy) break;
                this.max_occupancy = siteswapTreeItem.getNumberOfChildren();
                break;
            }
            case 6: {
                if (siteswapTreeItem.value <= this.max_throw) break;
                this.max_throw = siteswapTreeItem.value;
                break;
            }
            case 7: 
            case 8: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                    siteswapTreeItem.vanilla_asynch &= siteswapTreeItem2.vanilla_asynch;
                }
                break;
            }
            case 9: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum + siteswapTreeItem2.seq_beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                    siteswapTreeItem.vanilla_asynch &= siteswapTreeItem2.vanilla_asynch;
                }
                break;
            }
            case 10: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem2.left = i == 0;
                    siteswapTreeItem2.synch_throw = true;
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.throw_sum;
                }
                siteswapTreeItem.vanilla_asynch = false;
                break;
            }
            case 11: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    siteswapTreeItem2.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem2);
                    siteswapTreeItem.throw_sum += siteswapTreeItem2.value;
                }
                siteswapTreeItem.left = siteswapTreeItem.beatnum % 2 == 0 ? !this.right_on_even[siteswapTreeItem.source_juggler - 1] : this.right_on_even[siteswapTreeItem.source_juggler - 1];
                if (siteswapTreeItem.getNumberOfChildren() <= this.max_occupancy) break;
                this.max_occupancy = siteswapTreeItem.getNumberOfChildren();
                break;
            }
            case 12: {
                if (siteswapTreeItem.value <= this.max_throw) break;
                this.max_throw = siteswapTreeItem.value;
                break;
            }
            case 13: {
                if (siteswapTreeItem.transition != null) {
                    siteswapTreeItem.transition.beatnum = siteswapTreeItem.beatnum;
                    this.doFirstPass(siteswapTreeItem.transition);
                    siteswapTreeItem.throw_sum = siteswapTreeItem.transition.throw_sum;
                    siteswapTreeItem.vanilla_asynch = siteswapTreeItem.transition.vanilla_asynch;
                    siteswapTreeItem.beats = siteswapTreeItem.transition.beats;
                    break;
                }
                throw new JuggleExceptionInternal("Wildcard not resolved");
            }
            case 14: {
                this.right_on_even[siteswapTreeItem.source_juggler - 1] = siteswapTreeItem.beatnum % 2 == 0 ? !siteswapTreeItem.spec_left : siteswapTreeItem.spec_left;
                siteswapTreeItem.throw_sum = 0;
                if (siteswapTreeItem.beatnum <= 0) break;
                siteswapTreeItem.vanilla_asynch = false;
            }
        }
    }

    protected void doSecondPass(SiteswapTreeItem siteswapTreeItem, boolean bl, int n) throws JuggleExceptionUser {
        SiteswapTreeItem siteswapTreeItem2 = null;
        switch (siteswapTreeItem.type) {
            case 1: {
                int n2;
                for (n2 = 0; n2 < siteswapTreeItem.getNumberOfChildren(); ++n2) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(n2);
                    this.doSecondPass(siteswapTreeItem2, bl, n);
                }
                if (!siteswapTreeItem.switchrepeat) break;
                for (n2 = 0; n2 < siteswapTreeItem.getNumberOfChildren(); ++n2) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(n2);
                    this.doSecondPass(siteswapTreeItem2, !bl, n + siteswapTreeItem.beats / 2);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                for (int i = 0; i < siteswapTreeItem.getNumberOfChildren(); ++i) {
                    siteswapTreeItem2 = siteswapTreeItem.getChild(i);
                    this.doSecondPass(siteswapTreeItem2, bl, n);
                }
                break;
            }
            case 5: 
            case 11: {
                for (int i = siteswapTreeItem.beatnum + n; i < this.indexes; i += this.period) {
                    for (int j = 0; j < siteswapTreeItem.getNumberOfChildren(); ++j) {
                        int n3;
                        String string;
                        int n4;
                        siteswapTreeItem2 = siteswapTreeItem.getChild(j);
                        int n5 = bl ? (siteswapTreeItem.left ? 0 : 1) : (siteswapTreeItem.left ? 1 : 0);
                        int n6 = n4 = siteswapTreeItem2.value % 2 == 0 ? n5 : 1 - n5;
                        if (siteswapTreeItem2.x) {
                            n4 = 1 - n4;
                        }
                        if ((string = siteswapTreeItem2.mod) == null) {
                            string = "T";
                            if (siteswapTreeItem2.source_juggler == siteswapTreeItem2.dest_juggler && n5 == n4 && siteswapTreeItem2.value <= 2) {
                                string = "H";
                            }
                        }
                        if ((n3 = siteswapTreeItem2.dest_juggler) > this.getNumberOfJugglers()) {
                            n3 = 1 + (n3 - 1) % this.getNumberOfJugglers();
                        }
                        mhnThrow mhnThrow2 = new mhnThrow(siteswapTreeItem2.source_juggler, n5, i, j, n3, n4, i + siteswapTreeItem2.value, -1, string);
                        if (this.hands != null) {
                            int n7 = i;
                            if (siteswapTreeItem.synch_throw && n5 == 0) {
                                ++n7;
                            }
                            mhnThrow2.handsindex = n7 %= this.hands.getPeriod(siteswapTreeItem2.source_juggler);
                        }
                        this.th[siteswapTreeItem2.source_juggler - 1][n5][i][j] = mhnThrow2;
                    }
                }
                break;
            }
        }
    }
}

