/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import jugglinglab.renderer.JLMatrix;

public class JLVector {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;

    public JLVector() {
    }

    public JLVector(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public JLVector transform(JLMatrix jLMatrix) {
        double d = this.x * jLMatrix.m00 + this.y * jLMatrix.m01 + this.z * jLMatrix.m02 + jLMatrix.m03;
        double d2 = this.x * jLMatrix.m10 + this.y * jLMatrix.m11 + this.z * jLMatrix.m12 + jLMatrix.m13;
        double d3 = this.x * jLMatrix.m20 + this.y * jLMatrix.m21 + this.z * jLMatrix.m22 + jLMatrix.m23;
        return new JLVector(d, d2, d3);
    }

    public static JLVector add(JLVector jLVector, JLVector jLVector2) {
        return new JLVector(jLVector.x + jLVector2.x, jLVector.y + jLVector2.y, jLVector.z + jLVector2.z);
    }

    public static JLVector sub(JLVector jLVector, JLVector jLVector2) {
        return new JLVector(jLVector.x - jLVector2.x, jLVector.y - jLVector2.y, jLVector.z - jLVector2.z);
    }

    public static JLVector scale(double d, JLVector jLVector) {
        return new JLVector(d * jLVector.x, d * jLVector.y, d * jLVector.z);
    }
}

