/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import jugglinglab.jml.JMLPattern;
import jugglinglab.renderer.JLVector;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLMath;
import jugglinglab.util.JuggleExceptionInternal;

public class Juggler {
    public static final double shoulder_hw = 23.0;
    public static final double shoulder_h = 40.0;
    public static final double waist_hw = 17.0;
    public static final double waist_h = -5.0;
    public static final double elbow_hw = 30.0;
    public static final double elbow_h = 6.0;
    public static final double elbow_slop = 12.0;
    public static final double hand_out = 5.0;
    public static final double hand_in = 5.0;
    public static final double head_hw = 10.0;
    public static final double head_h = 26.0;
    public static final double neck_h = 5.0;
    public static final double shoulder_y = 0.0;
    public static final double pattern_y = 30.0;
    public static final double upper_length = 41.0;
    public static final double lower_length = 40.0;
    public static final double lower_gap_wrist = 1.0;
    public static final double lower_gap_elbow = 0.0;
    public static final double lower_hand_height = 0.0;
    public static final double upper_gap_elbow = 0.0;
    public static final double upper_gap_shoulder = 0.0;
    protected static final double lower_total = 41.0;
    protected static final double upper_total = 41.0;
    public static final double shoulder_radius = 6.0;
    public static final double elbow_radius = 4.0;
    public static final double wrist_radius = 2.0;

    public static void findJugglerCoordinates(JMLPattern jMLPattern, double d, JLVector[][] jLVectorArray) throws JuggleExceptionInternal {
        for (int i = 1; i <= jMLPattern.getNumberOfJugglers(); ++i) {
            JLVector jLVector;
            JLVector jLVector2;
            Coordinate coordinate = new Coordinate();
            Coordinate coordinate2 = new Coordinate();
            Coordinate coordinate3 = new Coordinate();
            jMLPattern.getHandCoordinate(i, 1, d, coordinate);
            jMLPattern.getHandCoordinate(i, 2, d, coordinate2);
            JLVector jLVector3 = new JLVector(coordinate.x, coordinate.z + 0.0, coordinate.y);
            JLVector jLVector4 = new JLVector(coordinate2.x, coordinate2.z + 0.0, coordinate2.y);
            jMLPattern.getJugglerPosition(i, d, coordinate3);
            double d2 = JLMath.toRad(jMLPattern.getJugglerAngle(i, d));
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            JLVector jLVector5 = new JLVector(coordinate3.x - 23.0 * d4 - 0.0 * d3, coordinate3.z + 40.0, coordinate3.y - 23.0 * d3 + 0.0 * d4);
            JLVector jLVector6 = new JLVector(coordinate3.x + 23.0 * d4 - 0.0 * d3, coordinate3.z + 40.0, coordinate3.y + 23.0 * d3 + 0.0 * d4);
            JLVector jLVector7 = new JLVector(coordinate3.x - 17.0 * d4 - 0.0 * d3, coordinate3.z + -5.0, coordinate3.y - 17.0 * d3 + 0.0 * d4);
            JLVector jLVector8 = new JLVector(coordinate3.x + 17.0 * d4 - 0.0 * d3, coordinate3.z + -5.0, coordinate3.y + 17.0 * d3 + 0.0 * d4);
            JLVector jLVector9 = new JLVector(coordinate3.x - 10.0 * d4 - 0.0 * d3, coordinate3.z + 40.0 + 5.0, coordinate3.y - 10.0 * d3 + 0.0 * d4);
            JLVector jLVector10 = new JLVector(coordinate3.x - 10.0 * d4 - 0.0 * d3, coordinate3.z + 40.0 + 5.0 + 26.0, coordinate3.y - 10.0 * d3 + 0.0 * d4);
            JLVector jLVector11 = new JLVector(coordinate3.x + 10.0 * d4 - 0.0 * d3, coordinate3.z + 40.0 + 5.0, coordinate3.y + 10.0 * d3 + 0.0 * d4);
            JLVector jLVector12 = new JLVector(coordinate3.x + 10.0 * d4 - 0.0 * d3, coordinate3.z + 40.0 + 5.0 + 26.0, coordinate3.y + 10.0 * d3 + 0.0 * d4);
            double d5 = 41.0;
            double d6 = 41.0;
            JLVector jLVector13 = JLVector.sub(jLVector3, jLVector5);
            double d7 = jLVector13.length();
            if (d7 <= d5 + d6) {
                double d8 = Math.sqrt((4.0 * d6 * d6 * d5 * d5 - (d6 * d6 + d5 * d5 - d7 * d7) * (d6 * d6 + d5 * d5 - d7 * d7)) / (4.0 * d7 * d7));
                if (Double.isNaN(d8)) {
                    throw new JuggleExceptionInternal("NaN in renderer 1");
                }
                double d9 = Math.sqrt(d6 * d6 - d8 * d8) / d7;
                if (Double.isNaN(d9)) {
                    throw new JuggleExceptionInternal("NaN in renderer 2");
                }
                JLVector jLVector14 = JLVector.scale(d9, jLVector13);
                double d10 = Math.asin(jLVector13.y / d7);
                if (Double.isNaN(d10)) {
                    throw new JuggleExceptionInternal("NaN in renderer 3");
                }
                d9 = 1.0 + d8 * Math.tan(d10) / (d9 * d7);
                jLVector2 = new JLVector(jLVector5.x + jLVector14.x * d9, jLVector5.y + jLVector14.y - d8 * Math.cos(d10), jLVector5.z + jLVector14.z * d9);
            } else {
                jLVector2 = null;
            }
            JLVector jLVector15 = JLVector.sub(jLVector4, jLVector6);
            d7 = jLVector15.length();
            if (d7 <= d5 + d6) {
                double d11 = Math.sqrt((4.0 * d6 * d6 * d5 * d5 - (d6 * d6 + d5 * d5 - d7 * d7) * (d6 * d6 + d5 * d5 - d7 * d7)) / (4.0 * d7 * d7));
                if (Double.isNaN(d11)) {
                    throw new JuggleExceptionInternal("NaN in renderer 4");
                }
                double d12 = Math.sqrt(d6 * d6 - d11 * d11) / d7;
                if (Double.isNaN(d12)) {
                    throw new JuggleExceptionInternal("NaN in renderer 5");
                }
                JLVector jLVector16 = JLVector.scale(d12, jLVector15);
                double d13 = Math.asin(jLVector15.y / d7);
                if (Double.isNaN(d13)) {
                    throw new JuggleExceptionInternal("NaN in renderer 6");
                }
                d12 = 1.0 + d11 * Math.tan(d13) / (d12 * d7);
                jLVector = new JLVector(jLVector6.x + jLVector16.x * d12, jLVector6.y + jLVector16.y - d11 * Math.cos(d13), jLVector6.z + jLVector16.z * d12);
            } else {
                jLVector = null;
            }
            jLVectorArray[i - 1][0] = jLVector3;
            jLVectorArray[i - 1][1] = jLVector4;
            jLVectorArray[i - 1][2] = jLVector5;
            jLVectorArray[i - 1][3] = jLVector6;
            jLVectorArray[i - 1][4] = jLVector2;
            jLVectorArray[i - 1][5] = jLVector;
            jLVectorArray[i - 1][6] = jLVector7;
            jLVectorArray[i - 1][7] = jLVector8;
            jLVectorArray[i - 1][8] = jLVector9;
            jLVectorArray[i - 1][9] = jLVector10;
            jLVectorArray[i - 1][10] = jLVector11;
            jLVectorArray[i - 1][11] = jLVector12;
        }
    }
}

