/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import jugglinglab.core.AnimatorEdit;
import jugglinglab.core.AnimatorPrefs;
import jugglinglab.core.EditLadderDiagram;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.View;

public class EditView
extends View {
    protected AnimatorEdit jae = null;
    protected JPanel ladder = null;
    protected static int ladder_width = 150;
    protected static int ladder_min_width = 80;

    public EditView(Dimension dimension) {
        this.setLayout(new BorderLayout());
        this.jae = new AnimatorEdit();
        this.jae.setJAPreferredSize(dimension);
        this.ladder = new JPanel();
        this.ladder.setLayout(new BorderLayout());
        this.ladder.setPreferredSize(new Dimension(ladder_width, 1));
        this.ladder.setMinimumSize(new Dimension(ladder_min_width, 1));
        this.ladder.setBackground(Color.white);
        JSplitPane jSplitPane = null;
        Locale locale = JLLocale.getLocale();
        if (ComponentOrientation.getOrientation(locale) == ComponentOrientation.LEFT_TO_RIGHT) {
            jSplitPane = new JSplitPane(1, true, this.jae, this.ladder);
            jSplitPane.setResizeWeight(1.0);
        } else {
            jSplitPane = new JSplitPane(1, true, this.ladder, this.jae);
            jSplitPane.setResizeWeight(0.0);
        }
        jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jSplitPane.setBackground(Color.white);
        this.setBackground(Color.white);
        this.add((Component)jSplitPane, "Center");
    }

    public void restartView() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.jae.restartJuggle();
    }

    public void restartView(JMLPattern jMLPattern, AnimatorPrefs animatorPrefs) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.jae.restartJuggle(jMLPattern, animatorPrefs);
        if (jMLPattern != null) {
            EditLadderDiagram editLadderDiagram = new EditLadderDiagram(jMLPattern, this.parent);
            editLadderDiagram.setAnimator(this.jae);
            this.jae.setLadderDiagram(editLadderDiagram);
            this.jae.deactivateEvent();
            editLadderDiagram.setPreferredSize(new Dimension(ladder_width, 1));
            editLadderDiagram.setMinimumSize(new Dimension(ladder_min_width, 1));
            this.ladder.removeAll();
            this.ladder.add((Component)editLadderDiagram, "Center");
            this.ladder.validate();
        }
    }

    public Dimension getAnimatorSize() {
        return this.jae.getSize(new Dimension());
    }

    public void dispose() {
        this.jae.dispose();
    }

    public JMLPattern getPattern() {
        return this.jae.getPattern();
    }

    public boolean getPaused() {
        return this.jae.getPaused();
    }

    public void setPaused(boolean bl) {
        if (this.jae.message == null) {
            this.jae.setPaused(bl);
        }
    }
}

