/* Interface between the PC juggling program and curses.
 * Copyright (C) 1991 John Robinson

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 1.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "curses.h"
#include "juggle.h"

/***************************************************************************
Modifications by John Robinson <jr@ksr.com>

 19-Nov-1991 : removed use of flushok(); it is not universal in curses, 
	       and doesn't seem to matter anyway.
***************************************************************************/

/* avoid roundoff error in the physics; power of 2 for speed */
#define CHEIGHT 16		/* approx character height in pixels */
#define CWIDTH  8		/* approx character width in pixels */

int cur_color;

/*========================================================================*/
Draw_Ball(int Tx, int Ty, int Tcolor, int Tsize)
{
    extern boolean do_numbers;

    if (Ty >= -CHEIGHT && Ty < LINES * CHEIGHT &&
	Tx >= -CWIDTH && Tx < COLS * CWIDTH) {
	move ((Ty + CHEIGHT)/CHEIGHT, (Tx + CWIDTH)/CWIDTH);
	if (do_numbers)
	    addch('1' + Tcolor%7);	/* some circle! */
	else
	    addch('O');
    }
}

/*========================================================================*/
UnDraw_Ball(int Tx, int Ty, int Tcolor, int Tsize)
{
    if (Ty >= -CHEIGHT && Ty < LINES * CHEIGHT &&
	Tx >= -CWIDTH && Tx < COLS * CWIDTH) {
	move ((Ty + CHEIGHT)/CHEIGHT, (Tx + CWIDTH)/CWIDTH);
	addch(' ');		/* erase old ball */
    }
}

/*========================================================================*/
AcidDraw_Ball(int Tx, int Ty, int Tcolor, int Tsize)
/* identical to DrawBall() */
{
    extern boolean do_numbers;

    if (Ty >= -CHEIGHT && Ty < LINES * CHEIGHT &&
	Tx >= -CWIDTH && Tx < COLS * CWIDTH) {
	move ((Ty + CHEIGHT)/CHEIGHT, (Tx + CWIDTH)/CWIDTH);
	if (do_numbers)
	    addch('1' + Tcolor%7);	/* some circle! */
	else
	    addch('O');
    }
}

cleardevice()
{
    move(1,1);
    refresh();
}

closegraph()
{
    clear();
    refresh();
    nocbreak();
    echo();
    endwin();
}

clrscr()
{
    clear();
    cur_color = BLACK;
}

detectgraph(driverp, modep)
     int *driverp, *modep;
{
    *driverp = 1;
    *modep = 1;
    initscr();
/*    flushok(stdscr,TRUE); non-standard, so removed.  */
    noecho();
    cbreak();
    nonl();
    move(1,1);
}

/* ARGSUSED */
    void
m_colormode(a)
    long a;
{
    return;
}

    long
getbkcolor()
{
    return((long)BLACK);
}

getmaxx()
{
    return (COLS * CWIDTH);
}

getmaxy()
{
    return (LINES * CHEIGHT);
}

gotoxy(x, y)
    int x, y;
{
    move(y, x);			/* unscaled */
}

/* ARGSUSED */
    char *
grapherrormsg(error)
    int error;
{
    static char* nuttin = "";

    return(nuttin);
}

int graphresult()
{
    return(0);
}

/* ARGSUSED */
void initgraph(driverp, modep, nullp)
    int *driverp, *modep, nullp;
{
    return;
}

/* ARGSUSED */
void setbkcolor(color)
     long color;
{
    return;
}

setcolor(i)
    long i;
{
    cur_color = i;
}

