/* Header file for compiling the PC juggling program for curses and Unix.
 * Copyright (C) 1991 John Robinson
 * Portions due to Allen Knutson [ALLENK], J. Gaudreau and 
 * Alastair Reid <areid@uk.ac.glasgow.dcs>.

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 1.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#define M_XOR 1
#define M_NORMAL 1

#ifdef IBMPC
#include <conio.h>
#include <stdlib.h>
#include <graphics.h>
#include "p2c.h"

#define jsleep(foo)		/* is there a timer func on IBMPCs? */

#else	/* IBMPC */
#define BLACK 0
#endif	/* IBMPC */

#ifdef NOANSI
#define void
#endif	/* NOANSI */

#ifndef HAVEBOOL
typedef short boolean;
#endif	/* HAVEBOOL */

#ifdef CURSES
#define printf printw

void m_colormode();
long getbkcolor();
char * grapherrormsg();
#endif	/* CURSES */

#define MAX_NUM_OPTIONS      20
#define MAX_NUM_HANDS	     10
#define MAX_PATTERN_LENGTH   60
#define TOTAL_PATTERN_LENGTH ((2 * MAX_PATTERN_LENGTH) + 1)
#define BITS_PER_LONG        32

typedef struct ball {
    short handfrom;
    short handto;
    boolean left_right;		/* left or right catch wanted */
    short throw;		/* how far ball has to go */
    short lateral;		/* how far ball has gone so far */
    long ox, oy, x, y;
#ifdef BITBLT
    void far *bitmap;
#endif
} ball;
 
/* 
throw == -2 => ball dropped
throw == -1 => ball in hand & lateral == time till next throw
throw > 0   => throw*2-lateral == time till next catch
*/

typedef struct hand {
    long x,y;
    long left_right;
    long scoop;			/* not currently used... but the potential is there */
} hand;

typedef struct worldvar {
    char title[256];
    long *vptr;

    boolean bounded;
    long lower, upper;

    long step;

    /* a slow variable should not be changed inside the animation loop - */
    /* so we store what value should be used and do the update outside */
    /* the loop. */
    boolean slow;
    long new_;

    long default_;

    boolean scaledep;		/* no longer used in an important way */
} worldvar;
