/* Interface between the PC juggling program and Unix, system V terminals.
 * Copyright (C) 1991 John Robinson

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 1.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <fcntl.h>
#include <stdio.h>
#include <errno.h>

char buf;	/* buffer for the character we read in */
int nread;	/* 1 if we read a character, else 0 or negative */

/* Find if any keyboard input is waiting */

kbhit()
{
  fcntl(fileno(stdin), F_SETFL, O_NDELAY);
  nread = read(fileno(stdin), &buf, 1);
  if (nread == -1 && errno == EAGAIN)
    nread = 0;
  fcntl(fileno(stdin), F_SETFL, 0);
  return(nread == 1);
}

/* Retrieve the character from its buffer */

getch()
{
    return(nread == 1 ? buf : 0);
}
