/*
 * Basic X program framework from xball:
 * Drawing Balls, Handling X Events, and Stuff.
 *
 * Put together by : Joe Gaudreau.
 *
 * Thanx to David Nedde (daven@maxine.wpi.edu) for writing Xball.
 *
 */

/* Changed 16/9/91 by Alastair Reid to allow resizing.
 *   Principal change is that xview now deals with a "virtual"
 *   interface WIN_WIDTH wide and WIN_HEIGHT high and that
 *   xTens magnifies any coordinates according to the current
 *   magnification as determined by current window size.
 * Changed 17/9/91 by Alastair Reid to return keyboard input to
 *   main program.
 */

#define NeedFunctionPrototypes 0

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include <stdio.h>
#include <strings.h>

extern void redo_screen(void);

#define TRUE  1
#define FALSE 0

#define WIN_WIDTH  1000
#define WIN_HEIGHT 1000

#define ITEM_WIDTH  10
#define ITEM_HEIGHT 10

#define MAX_COLOR_BLTS 16


typedef struct {

  Display *MyDisplay;
  int	   MyScreen;
  Window   MyWindow;

  Colormap MyColormap;

  GC       DrawGC;
  GC       UnDrawGC;
  GC       ResetGC;

  GC	   ColorGC;
  int	   BitDepth;
  int	   Mono;

  int	   X,
           Y;

  int	   Width,
           Height;

} MyWinObjectType;


/* Look ma, them thar's global variables */

int      MyItemIndex   = 0;
int      MyMaxColor;
int      curr_pixmap;
MyWinObjectType MyWinObject;

XEvent MyWinEvent;
KeySym MyKey;
Pixmap MyBitsToBlt[MAX_COLOR_BLTS];

int    MyDone;

int   cur_width, cur_height;

char kbdin[1000];	/* returns keyboard input */
int  kbdlen;		/* returns length of keyboard input */

Translate_Coordinates(int *Tx, int *Ty)
{
  *Tx=((*Tx-WIN_WIDTH/2) * cur_width) / WIN_WIDTH + cur_width/2;
  *Ty=((*Ty-WIN_HEIGHT/2) * cur_height) / WIN_HEIGHT + cur_height/2 +
ITEM_HEIGHT;
}

/*========================================================================*/
Draw_Ball(int Tx, int Ty, int Tcolor, int Tsize)
{
    if (Tcolor >= MyMaxColor)
	Tcolor = 0;

    Translate_Coordinates(&Tx,&Ty);
    XCopyArea(MyWinObject.MyDisplay,
	      MyBitsToBlt[Tcolor],
	      MyWinObject.MyWindow,
	      MyWinObject.DrawGC,
	      0, 0, ITEM_WIDTH, ITEM_HEIGHT,
	      Tx - ITEM_WIDTH/2,
	      Ty - ITEM_HEIGHT/2
	      );

} /*Draw_Ball*/


/*========================================================================*/
UnDraw_Ball(int Tx, int Ty, int Tcolor, int Tsize)
{
    if (Tcolor >= MyMaxColor)
	Tcolor = 0;

    Translate_Coordinates(&Tx,&Ty);
    XCopyArea(MyWinObject.MyDisplay,
	      MyBitsToBlt[Tcolor],
	      MyWinObject.MyWindow,
	      MyWinObject.DrawGC,
	      0, 0, ITEM_WIDTH, ITEM_HEIGHT,
	      Tx - ITEM_WIDTH/2,
	      Ty - ITEM_HEIGHT/2
	      );

} /*UnDraw_Ball*/


/*========================================================================*/
AcidDraw_Ball(int Tx, int Ty, int Tcolor, int Tsize)
{
    if (Tcolor >= MyMaxColor)
	Tcolor = 0;

    Translate_Coordinates(&Tx,&Ty);
    XCopyArea(MyWinObject.MyDisplay,
	      MyBitsToBlt[Tcolor],
	      MyWinObject.MyWindow,
	      MyWinObject.ResetGC,
	      0, 0, ITEM_WIDTH, ITEM_HEIGHT,
	      Tx - ITEM_WIDTH/2,
	      Ty - ITEM_HEIGHT/2
	      );

} /*AcidDraw_Ball*/

/*========================================================================*/

JClearScreen(void)
{
  XClearWindow( MyWinObject.MyDisplay, MyWinObject.MyWindow );
}


/*========================================================================*/
JballEvent(char text[10], int *i)
 /* Holds keypress response text */
{
  int x;

  *i = 0; /* no keyboard input from most events */
  if (XEventsQueued( MyWinObject.MyDisplay, QueuedAfterReading) == 0) {
    XFlush( MyWinObject.MyDisplay);
  } else {
    XNextEvent( MyWinObject.MyDisplay, &MyWinEvent);

    switch (MyWinEvent.type) {
    case Expose: /* Repaint MyWindow on expose event */
      /* Wait until last expose event */
      if (MyWinEvent.xexpose.count == 0) {
	redo_screen();
      }
      break;
    case MappingNotify: /* Process keyboard mapping changes */
      XRefreshKeyboardMapping(&MyWinEvent);
      break;
    case ConfigureNotify: /* Reset bounderies if window resized */
      cur_width = MyWinEvent.xconfigure.width;
      cur_height = MyWinEvent.xconfigure.height-ITEM_HEIGHT*2;
      redo_screen(); /* Clear screen and redraw all items */
      break;
    case KeyPress: /* Process keyboard input */
      *i = XLookupString( &MyWinEvent, text, 10, &MyKey, 0);
      break;
    case ButtonPress:
    case ButtonRelease:
    case CirculateNotify:
    case DestroyNotify:
    case GravityNotify:
    case MapNotify:
    case ReparentNotify:
    case UnmapNotify:
    case CreateNotify:
    case MotionNotify:
      break;
    } /*switch*/
  } /*if*/
} /*JballEvent*


/*========================================================================*/
JballBegin(int argc, char **argv)
{

  MyWinObject.Width  = WIN_WIDTH/5;
  MyWinObject.Height = WIN_HEIGHT/5;
  MyWinObject.X      = 0;
  MyWinObject.Y      = 0;

/*get params and stuff here */

  Init_Frame(argc, argv, &MyWinObject, "JuGGle ViEwer");

  XSelectInput(
	       MyWinObject.MyDisplay,
	       MyWinObject.MyWindow,
	           PointerMotionMask | ButtonPressMask | KeyPressMask |
	           ButtonReleaseMask | ExposureMask    | StructureNotifyMask
	       );

  Do_Map_Colors();

  XMapRaised(
	     MyWinObject.MyDisplay,
	     MyWinObject.MyWindow
	     );

  XSetFunction(
	       MyWinObject.MyDisplay,
	       MyWinObject.DrawGC,
/*	       GXxor */
	       GXxor
	       );

  XCopyGC(
	  MyWinObject.MyDisplay,
	  MyWinObject.DrawGC,
	  0x3fffffL,
	  MyWinObject.UnDrawGC
	  );

} /*JballBegin*/


/*========================================================================*/
JballEnd()
{

  XFreeGC( MyWinObject.MyDisplay, MyWinObject.DrawGC);
  XFreeGC( MyWinObject.MyDisplay, MyWinObject.UnDrawGC);
  XFreeGC( MyWinObject.MyDisplay, MyWinObject.ResetGC);
  XDestroyWindow( MyWinObject.MyDisplay, MyWinObject.MyWindow);
  XCloseDisplay( MyWinObject.MyDisplay);
} /*JballEnd*/


/*========================================================================*/
Do_Map_Colors()
{

#if 1

/* Setup a different colored item for each available color */
  if (MyWinObject.Mono)
  {
    MyMaxColor = 0;

    /* Create pixmap for item */
    MyBitsToBlt[MyMaxColor] =
	XCreatePixmap(
		      MyWinObject.MyDisplay,
		      MyWinObject.MyWindow,
		      ITEM_WIDTH, ITEM_HEIGHT,
		      DefaultDepth( MyWinObject.MyDisplay,
				   MyWinObject.MyScreen)
		      );

    /* Clear pixmap */
    XFillRectangle(
		   MyWinObject.MyDisplay,
		   MyBitsToBlt[MyMaxColor],
		   MyWinObject.ResetGC,
		   0, 0,
		   ITEM_WIDTH, ITEM_HEIGHT
		   );

    /* Draw item */
    XDrawArc(
	     MyWinObject.MyDisplay,
	     MyBitsToBlt[MyMaxColor],
	     MyWinObject.DrawGC,
	     0, 0,
	     ITEM_WIDTH-1, ITEM_HEIGHT-1,
	     0, 360*64
	     );
    XFillArc(
	     MyWinObject.MyDisplay,
	     MyBitsToBlt[MyMaxColor],
	     MyWinObject.DrawGC,
	     0, 0,
	     ITEM_WIDTH-1, ITEM_HEIGHT-1,
	     0, 360*64
	     );
    MyMaxColor++;

  } else {

    XColor   color;
    int      cells[10];


    color.flags = DoRed | DoGreen | DoBlue;
    curr_pixmap = 0;

/* I suspect there is a problem if the server runs out of colours to
   allocate - but I'm not sure what the problem is.
*/

    for (MyMaxColor = 0; MyMaxColor < MAX_COLOR_BLTS; MyMaxColor++) {
	if (!XAllocColorCells (
			       MyWinObject.MyDisplay,
			       MyWinObject.MyColormap,
			       TRUE,
			       NULL,
			       0, cells,1
			       )
	    ) {
	    break; /* Can't allocate any more colors */
	}

      color.red   = random()%65535;
      color.green = random()%65535;
      color.blue  = random()%65535;

      color.pixel = cells[0];

      XStoreColor(
		  MyWinObject.MyDisplay,
		  MyWinObject.MyColormap,
		  &color
		  );

      /* Create pixmap for item */
      MyBitsToBlt[MyMaxColor] =
	  XCreatePixmap(
			MyWinObject.MyDisplay,
			MyWinObject.MyWindow,
			ITEM_WIDTH, ITEM_HEIGHT,
			DefaultDepth(MyWinObject.MyDisplay,
				     MyWinObject.MyScreen
				     )
			);

      /* Clear pixmap */
      XFillRectangle(
		     MyWinObject.MyDisplay,
		     MyBitsToBlt[MyMaxColor],
		     MyWinObject.ResetGC,
		     0, 0,
		     ITEM_WIDTH, ITEM_HEIGHT
		     );

      /* Draw item */
      XSetForeground(
		     MyWinObject.MyDisplay,
		     MyWinObject.ColorGC,
		     color.pixel
		     );

      XDrawArc(
	       MyWinObject.MyDisplay,
	       MyBitsToBlt[MyMaxColor],
	       MyWinObject.ColorGC,
	       0, 0,
	       ITEM_WIDTH-1,
	       ITEM_HEIGHT-1,
	       0, 360*64
	       );

      XFillArc(
	       MyWinObject.MyDisplay,
	       MyBitsToBlt[MyMaxColor],
	       MyWinObject.ColorGC,
	       0, 0,
	       ITEM_WIDTH-1,
	       ITEM_HEIGHT-1,
	       0, 360*64
	       );
    }
  }

#endif


} /*Do_Map_Colors*/


/*========================================================================*/
Init_Frame(int argc, char **argv, MyWinObjectType *MyWinObject, char *MyTitle)
{

  XSizeHints XHints;
  int MyWinFG, MyWinBG;


  if ((MyWinObject->MyDisplay = XOpenDisplay("")) == NULL) {
      fprintf(stderr, "%s: Cannot connect to X server '%s'\n", argv[0],
	      XDisplayName(""));
      exit(1);
  }

  MyWinObject->MyScreen = DefaultScreen(MyWinObject->MyDisplay);

  MyWinBG = WhitePixel(MyWinObject->MyDisplay, MyWinObject->MyScreen);
  MyWinFG = BlackPixel(MyWinObject->MyDisplay, MyWinObject->MyScreen);

  XHints.x      = MyWinObject->X;
  XHints.y      = MyWinObject->Y;
  XHints.width  = MyWinObject->Width;
  XHints.height = MyWinObject->Height;
  XHints.flags  = PPosition | PSize;

  MyWinObject->MyWindow =
      XCreateSimpleWindow(
			  MyWinObject->MyDisplay,
			  DefaultRootWindow(MyWinObject->MyDisplay),
			  XHints.x,
			  XHints.y,
			  XHints.width,
			  XHints.height,
			  5,
			  MyWinFG,
			  MyWinBG
			  );

  XSetStandardProperties(
			 MyWinObject->MyDisplay,
			 MyWinObject->MyWindow,
			 MyTitle,
			 MyTitle,
			 None,
			 argv,
			 argc,
			 &XHints
			 );

  /* Create drawing and erasing GC */

  MyWinObject->DrawGC =
      XCreateGC(
		MyWinObject->MyDisplay,
		MyWinObject->MyWindow,
		0, 0
		);
  XSetBackground(
		 MyWinObject->MyDisplay,
		 MyWinObject->DrawGC,
		 MyWinBG
		 );
  XSetForeground(
		 MyWinObject->MyDisplay,
		 MyWinObject->DrawGC,
		 MyWinFG
		 );
  XSetGraphicsExposures(
			MyWinObject->MyDisplay,
			MyWinObject->DrawGC,False
			);


  MyWinObject->UnDrawGC =
      XCreateGC(
		MyWinObject->MyDisplay,
		MyWinObject->MyWindow,
		0, 0
		);


  MyWinObject->ResetGC =
      XCreateGC(
		MyWinObject->MyDisplay,
		MyWinObject->MyWindow,
		0, 0
		);
  XSetBackground(
		 MyWinObject->MyDisplay,
		 MyWinObject->ResetGC,
		 MyWinFG
		 );
  XSetForeground(
		 MyWinObject->MyDisplay,
		 MyWinObject->ResetGC,
		 MyWinBG
		 );
  XSetGraphicsExposures(
			MyWinObject->MyDisplay,
			MyWinObject->ResetGC,
			False
			);


  MyWinObject->ColorGC =
      XCreateGC(
		MyWinObject->MyDisplay,
		MyWinObject->MyWindow,
		0, 0
		);
  XSetBackground(
		 MyWinObject->MyDisplay,
		 MyWinObject->ColorGC,
		 MyWinBG
		 );
  XSetForeground(
		 MyWinObject->MyDisplay,
		 MyWinObject->ColorGC,
		 MyWinFG
		 );
  XSetGraphicsExposures(
			MyWinObject->MyDisplay,
			MyWinObject->ColorGC,
			False
			);

  XMapRaised(
	     MyWinObject->MyDisplay,
	     MyWinObject->MyWindow
	     );

  MyWinObject->MyColormap =
      DefaultColormap(
		      MyWinObject->MyDisplay,
		      MyWinObject->MyScreen
		      );
  XSetWindowColormap(
		     MyWinObject->MyDisplay,
		     MyWinObject->MyWindow,
		     MyWinObject->MyColormap
		     );

  MyWinObject->BitDepth =
      DisplayCells(
		   MyWinObject->MyDisplay,
		   MyWinObject->MyScreen
		   );
  MyWinObject->Mono = (MyWinObject->BitDepth == 2);

}

getmaxx()
{
    return (WIN_WIDTH);
}

getmaxy()
{
    return (WIN_HEIGHT);
}

int kbhit()
{
    JballEvent(kbdin,&kbdlen);
    if (kbdlen > 1)
	fprintf(stderr, "Warning: lost input character\n");
    return(kbdlen > 0);
}

int getch()
{
    return(kbdin[0]);
}

void closegraph(void)
{  
  JballEnd();
}

/* see JClearScreen() above */
void clrscr(void)
{
  XClearWindow( MyWinObject.MyDisplay, MyWinObject.MyWindow );
}

int graphresult(void)
{
return (0);
}

/* stub routines for unused IBMPC-style calls */
/* for speed, define these to be empty macros instead */

void cleardevice(void)
{}

void detectgraph(void)
{}

void gotoxy(void)
{}

void grapherrormsg(void)
{}

void m_colormode(void)
{}

void setbkcolor(void)
{}

/*eof*/
