#include "uniform.h"
#include <iostream>
#include <cstdlib>
#include <ctime>
#include <plotter.h> 
using namespace std;

/* Elementary and rudimentary juggling code by Harri V. from summer 2014 */
/* Uses X Plotter library for graphics, should be changed to something smarter */
/* Task: improve by studying Knutson's code and the code for Juggling Lab */

void delay(int msec) {
	clock_t t = clock();
	while(difftime(clock(),t) < msec) {
		;
	}
}

int main() {

	/* maximum height */
	long m;
	cout << "Give the maximum height: ";
	cin >> m;

	/* create an empty state of size m */
	bool* state = new bool[m];
	for(long i=0; i<m; i++) {
		state[i]=0;
	}

	/* uniformly random number of particles n between 1 and m */
	seed();
	long n=unif(m);
	n=unif(m); // seems to be needed twice - why?

	/* fill the state with a lowest ball (for simplicity) and n-1 random balls */
	state[0]=1; 
	for(long i=1; i<n; i++) {
		bool filled=0;
		while(!filled) {
			long j = unif(m)-1;
			if(!state[j]) {
				state[j]=1;
				filled=1;
			}
		}
	}

	/* display the state */
	cout << "A random state with " << n << " particles: ";
	for(long i=0; i<m; i++) {
		if (state[i]) {
			cout << "x";
		}
		else {
			cout << "-";
		}
	}
	cout << endl;
	cout << endl;

	/* display the possible throws */
	cout << "Possible throws: ";
	for (long i=0; i<m; i++) {
		if (!state[i]) {
			cout << i << ", ";
		}
	}
	cout << m;
	cout << "." << endl;
	cout << endl;

	/* prompt for a throw */
	cout << "Throw: ";
	long t;
	cin >> t;

	/* determine the next state */
	bool* nextstate = new bool[m];
	for (int i=0; i<m-1; i++) {
		nextstate[i]=state[i+1];
	}
	nextstate[t-1]=1;

	/* display the next state */
	cout << "State after throw: ";
	for(long i=0; i<m; i++) {
		if (nextstate[i]) {
			cout << "x";
		}
		else {
			cout << "-";
		}
	}
	cout << endl;

	/* wait a bit until graphics */
	cout << "Waiting two seconds until displaying graphics..." << endl;
	delay(2000000);

	/* Create and open an X plotter */
	PlotterParams params;
	params.setplparam("BITMAPSIZE", (char *)"1380x680");
	params.setplparam("VANISH_ON_DELETE", (char *)"yes");
	params.setplparam("USE_DOUBLE_BUFFERING", (char *)"yes");
 
	XPlotter P(cin, cout, cerr, params);

	if (P.openpl() < 0) {
		cerr << "Unable to open plotter" << endl;
		return 1;
	}

	/* specify user coordinates (xmin, ymin, xmax, ymax) to the 1380x680 screen */
	P.fspace(-690, 0, 690, 680); // TODO: with variables

	/* parabola from user coordinates */
	float sidemargin = 1380*0.2;
	float topbotmargin = 680*0.2;
	float left_x = -690+sidemargin;
	float right_x = 690-sidemargin;
	float bottom_y = 0+topbotmargin;
	float top_y = 680-topbotmargin;
	float k = (bottom_y-top_y)/(right_x*right_x); // parabola: y - top_y = kx^2

   P.linewidth(3); // line thickness 
   P.filltype(1); // objects will be filled 
	P.colorname("black"); // use black in both pen and filling
   P.bgcolorname("saddle brown"); // bgcolor 

	P.erase(); 

	/* wait a second (otherwise start of ball flight invisible) */
	delay(1000000);

	/* let us throw a five */
	int duration=5*10000; // five seconds
	clock_t start = clock();
	clock_t current = start; 
	clock_t elapsed = current-start;
	float x,y;
	while ((int)elapsed <= duration) {
		x=(float)left_x+(float)elapsed/(float)duration*(float)(right_x-left_x);
		y=k*x*x+top_y;
      P.circle(x, y, 10); // place circle on parabola
		P.erase();
		current = clock();
		elapsed = current-start;
   }

	/* close plotter */
	if (P.closepl() < 0) {
		cerr << "Unable to close plotter" << endl;
		return 1;
	}

	delete[] state;
	delete[] nextstate;
	return(0);
}

